% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_residuals.R
\name{check_residuals.ts}
\alias{check_residuals.ts}
\alias{check_residuals}
\alias{check_residuals.arima0}
\alias{check_residuals.Arima}
\alias{check_residuals.fGarch}
\alias{check_residuals.numeric}
\alias{check_residuals.lm}
\alias{check_residuals.HoltWinters}
\alias{check_residuals.ets}
\alias{check_residuals.forecast}
\title{Generic functions for checking residuals in time series models}
\usage{
\method{check_residuals}{ts}(
  y,
  normality = "epps",
  unit_root = NULL,
  seasonal = NULL,
  arch = NULL,
  alpha = 0.05,
  plot = FALSE,
  ...
)
}
\arguments{
\item{y}{Either a time series model,the supported classes are \code{arima0}, \code{Arima}, \code{sarima},
\code{fGarch}, or a time series (assumed to be residuals).}

\item{normality}{A character string naming the desired test for checking gaussian distribution.
Valid values are \code{"epps"} for the Epps, \code{"lobato"} for Lobato and Velasco's,\code{"vavras"} for
the Psaradakis and  Vávra, \code{"rp"} for the random projections, \code{"jb"} for the Jarque and Bera,
\code{"ad"} for Anderson Darling test, and \code{"shapiro"} for the Shapiro-Wilk's test. The default value
is \code{"epps"} test.}

\item{unit_root}{A character string naming the desired unit root test for checking stationarity.
Valid values are \code{"adf"} for the Augmented Dickey-Fuller, \code{"pp"} for the Phillips-Perron,
and \code{"kpss"} for Kwiatkowski, Phillips, Schmidt, and Shin. The default value is \code{"adf"} for the
Augmented Dickey-Fuller test.}

\item{seasonal}{A character string naming the desired unit root test for checking seasonality.
Valid values are \code{"ocsb"} for the Osborn, Chui, Smith, and Birchenhall, \code{"ch"} for the
Canova and Hansen, and \code{"hegy"} for Hylleberg, Engle, Granger, and Yoo. The default value is
\code{"ocsb"} for the Osborn, Chui, Smith, and Birchenhall test.}

\item{arch}{A character string naming the desired  test for checking stationarity. Valid values are
\code{"box"} for the Ljung-Box, and \code{"Lm"} for the Lagrange Multiplier test. The default
value is \code{"box"} for the Augmented Ljung-Box test.}

\item{alpha}{Level of the test, possible values range from 0.01 to 0.1. By default \code{alpha = 0.05}
is used}

\item{plot}{A boolean value. If \code{TRUE}, will produce produces a time plot of the residuals,
the corresponding ACF, and a histogram.}

\item{...}{Other testing parameters}
}
\value{
The function does not return any value
}
\description{
Generic function for residuals check analysis, these methods are inspired in the \code{check.residuals} function
provided by the \code{forecast} package.
}
\details{
The function performs a residuals analysis, it prints a unit root and seasonal test to check
stationarity, and a normality test for checking  Gaussian distribution. In addition, if the plot option is
\code{TRUE} a time plot, ACF, and histogram of the series are presented.
}
\examples{
# Generating an stationary arma process
y = arima.sim(100,model = list(ar = 0.3))
check_residuals(y,unit_root = "adf")

}
\references{
Dickey, D. & Fuller, W. (1979). Distribution of the Estimators for
Autoregressive Time Series with a Unit Root. \emph{Journal of the American
Statistical Association}. 74, 427-431.

Epps, T.W. (1987). Testing that a stationary time series is Gaussian. \emph{The
Annals of Statistic}. 15(4), 1683-1698.http://www.jstor.org/stable/2336512.
\code{doi:10.1214/aos/1176350618}

Osborn, D., Chui, A., Smith, J., & Birchenhall, C. (1988). Seasonality and the
order of integration for consumption. \emph{Oxford Bulletin of Economics
and Statistics}. 50(4), 361-377.
}
\author{
Asael Alonzo Matamoros
}
