% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Result.R
\docType{methods}
\name{AthenaResult}
\alias{AthenaResult}
\alias{AthenaResult-class}
\alias{dbClearResult,AthenaResult-method}
\alias{dbFetch,AthenaResult-method}
\alias{dbHasCompleted,AthenaResult-method}
\alias{dbIsValid,AthenaResult-method}
\alias{dbGetInfo,AthenaResult-method}
\alias{dbColumnInfo,AthenaResult-method}
\alias{dbStatistics}
\alias{dbStatistics,AthenaResult-method}
\alias{dbGetStatement,AthenaResult-method}
\title{Athena Result Methods}
\usage{
\S4method{dbClearResult}{AthenaResult}(res, ...)

\S4method{dbFetch}{AthenaResult}(res, n = -1, ...)

\S4method{dbHasCompleted}{AthenaResult}(res, ...)

\S4method{dbIsValid}{AthenaResult}(dbObj, ...)

\S4method{dbGetInfo}{AthenaResult}(dbObj, ...)

\S4method{dbColumnInfo}{AthenaResult}(res, ...)

dbStatistics(res, ...)

\S4method{dbStatistics}{AthenaResult}(res, ...)

\S4method{dbGetStatement}{AthenaResult}(res, ...)
}
\arguments{
\item{res}{An object inheriting from \link[DBI:DBIResult-class]{DBI::DBIResult}.}

\item{...}{Other arguments passed on to methods.}

\item{n}{maximum number of records to retrieve per fetch. Use \code{n = -1}
or \code{n = Inf}
to retrieve all pending records.  Some implementations may recognize other
special values.}

\item{dbObj}{An object inheriting from \link[DBI:DBIResult-class]{DBI::DBIResult},
\link[DBI:DBIConnection-class]{DBI::DBIConnection}, or \link[DBI:DBIDriver-class]{DBI::DBIDriver}.}
}
\value{
\code{dbStatistics()} returns list containing Athena Statistics return from \code{paws}.
}
\description{
Implementations of pure virtual functions defined in the \code{DBI} package
for AthenaResult objects.

Returns AWS Athena Statistics from execute queries \link[DBI:dbSendQuery]{DBI::dbSendQuery}
}
\note{
If a user does not have permission to remove AWS S3 resource from AWS Athena output location, then an AWS warning will be returned.
For example \code{AccessDenied (HTTP 403). Access Denied}.
It is better use query caching or optionally prevent clear AWS S3 resource using \link{noctua_options}
}
