% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addBaseline.R
\name{addBaseline1exp}
\alias{addBaseline1exp}
\title{Add baseline that decays exponential with time}
\usage{
addBaseline1exp(ui, effect = "effect", eb = "Eb", time = "time", kb = "kb")
}
\arguments{
\item{ui}{rxode2 model}

\item{effect}{the effect variable that will be modeled}

\item{eb}{baseline constant parameter}

\item{time}{the time or other variable used for baseline decay}

\item{kb}{the first order baseline decay constant}
}
\value{
model with baseline constant
}
\description{
Add baseline that decays exponential with time
}
\examples{
 readModelDb("PK_2cmt_no_depot") |>
  addDirectLin() |>
  convertQuad() |>
  addBaseline1exp()
}
\seealso{
Other PD: 
\code{\link{addBaselineConst}()},
\code{\link{addBaselineExp}()},
\code{\link{addBaselineLin}()},
\code{\link{addDirectLin}()},
\code{\link{convertEmax}()},
\code{\link{convertLogLin}()},
\code{\link{convertQuad}()}
}
\author{
Matthew L. Fidler
}
\concept{PD}
