% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Laplace.R
\name{runLaplace}
\alias{runLaplace}
\alias{runAGHQ}
\title{Combine steps of running Laplace or adaptive Gauss-Hermite quadrature approximation}
\usage{
runLaplace(
  laplace,
  pStart,
  originalScale = TRUE,
  randomEffectsStdError = TRUE,
  jointCovariance = FALSE
)

runAGHQ(
  AGHQ,
  pStart,
  originalScale = TRUE,
  randomEffectsStdError = TRUE,
  jointCovariance = FALSE
)
}
\arguments{
\item{laplace}{A (compiled or uncompiled) nimble laplace approximation object
returned from `buildLaplace` or `buildAGHQ`. These return the same type of
approximation algorithm object. `buildLaplace` is simply `buildAGHQ`
with `nQuad=1`.}

\item{pStart}{Initial values for parameters to begin optimization search for
the maximum likelihood estimates. If omitted, the values currently in the
(compiled or uncompiled) model object will be used.}

\item{originalScale}{If \code{TRUE}, return all results on the original scale
of the parameters and/or random effects as written in the model. Otherwise,
return all results on potentially unconstrained transformed scales that are
used in the actual computations. Transformed scales (parameterizations) are
used if any parameter or random effect has contraint(s) on its support
(range of allowed values). Default = \code{TRUE}.}

\item{randomEffectsStdError}{If \code{TRUE}, include standard errors for the
random effects estimates. Default = \code{TRUE}.}

\item{jointCovariance}{If \code{TRUE}, return the full joint covariance
matrix (inverse of the Hessian) of parameters and random effects. Default =
\code{FALSE}.}

\item{AGHQ}{Same as \code{laplace}.}
}
\value{
A list with elements \code{MLE} and \code{summary}.

\code{MLE} is the result of the \code{findMLE} method, which contains the
parameter estimates and Hessian matrix. This is considered raw output, and
one should normally use the contents of \code{summary} instead. (For example
note that the Hessian matrix in \code{MLE} may not correspond to the same
scale as the parameter estimates if a transformation was used to operate in
an unconstrained parameter space.)

\code{summary} is the result of \code{summaryLaplace} (or equivalently
\code{summaryAGHQ}), which contains parameter estimates and standard errors,
and optionally other requested components. All results in this object will be
on the same scale (parameterization), either original or transformed, as
requested.
}
\description{
Use an approximation (compiled or uncompiled) returned from
`buildLaplace` or `buildAGHQ` to find the maximum likelihood estimate and return it
with random effects estimates and/or standard errors.
}
\details{
Adaptive Gauss-Hermite quadrature is a generalization of Laplace
approximation. \code{runLaplace} simply calles \code{runAGHQ} and provides a
convenient name.

These functions manage the steps of calling the `findMLE` method to obtain
the maximum likelihood estimate of the parameters and then the
`summaryLaplace` function to obtain standard errors, (optionally) random
effects estimates (conditional modes), their standard errors, and the full
parameter-random effects covariance matrix.

Note that for `nQuad > 1` (see \code{\link{buildAGHQ}}), i.e., AGHQ with
higher order than Laplace approximation, maximum likelihood estimation is
available only if all random effects integrations are univariate. With
multivariate random effects integrations, one can use `nQuad > 1` only to
calculate marginal log likelihoods at given parameter values. This is useful
for checking the accuracy of the log likelihood at the MLE obtained for
Laplace approximation (`nQuad == 1`). `nQuad` can be changed using the
`updateSettings` method of the approximation object.

See \code{\link{summaryLaplace}}, which is called for the summary components.
}
