% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dTrapezoidal.R
\name{dTrapezoidal}
\alias{dTrapezoidal}
\alias{rTrapezoidal}
\title{Trapezoidal Distribution}
\usage{
dTrapezoidal(x, a, m1, m2, b, log)

rTrapezoidal(n, a, m1, m2, b)
}
\arguments{
\item{x}{A calendar year (in BP).}

\item{a}{lower (earliest) limit of the distribution (in BP).}

\item{m1}{lower mode (in BP)}

\item{m2}{upper mode (in BP).}

\item{b}{upper (latest) limit of the distribution (in BP).}

\item{log}{TRUE or 1 to return log probability. FALSE or 0 to return probability.}

\item{n}{number of random draws. Currently only n = 1 is supported, but the argument exists for standardization of "r" functions.}
}
\description{
Density and random generation of an Trapezoidal distribution.
}
\examples{
a=7000
b=6700
c=4000
d=3000
x=5400
modelPlot(dTrapezoidal,a=7000,b=5000,params=c(m1=6000,m2=5300),alpha=1,col=1)

}
\author{
Enrico Crema
}
