% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Team.R
\name{get_team_roster}
\alias{get_team_roster}
\title{Get roster by team, season, and player-type}
\usage{
get_team_roster(
  team = "BOS",
  season = get_season_now()$seasonId,
  player_type = "forwards"
)
}
\arguments{
\item{team}{string 3-letter Code}

\item{season}{integer in YYYYYYYY}

\item{player_type}{string of 'forwards', 'defensemen', or 'goalies'}
}
\value{
tibble with one row per player
}
\description{
\code{get_team_roster()} retrieves information on each player for a given set of \code{team}, \code{season}, and \code{player_type}, including but not limited to their ID, name, bio-metrics, and birth date and location. Access \code{get_teams()} for \code{team} and \code{get_team_seasons()} for \code{season} references.
}
\examples{
COL_defensemen_20242025 <- get_team_roster(
  team='COL',
  season=20242025,
  player_type='defensemen'
)
}
