% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_generic.R
\name{partial_project}
\alias{partial_project}
\title{Partially project a new sample onto subspace}
\usage{
partial_project(x, new_data, colind, least_squares = TRUE, lambda = 1e-06, ...)
}
\arguments{
\item{x}{The fitted model, e.g. \code{bi_projector}, that has a partial_project method.}

\item{new_data}{A numeric matrix (n x length(colind)) or vector, representing
the observations to be projected.}

\item{colind}{A numeric vector of column indices in the original data space
that correspond to \code{new_data}'s columns.}

\item{least_squares}{Logical; if TRUE (default), do a ridge-regularized solve.}

\item{lambda}{Numeric; ridge penalty (default 1e-6). Ignored if \code{least_squares=FALSE}.}

\item{...}{Additional arguments passed to class-specific partial_project methods.}
}
\value{
A numeric matrix (n x d) of factor scores in the model's subspace, for
those columns only.
}
\description{
Project a selected subset of column indices (\code{colind}) of \code{new_data} onto
the subspace defined by the model \code{x}. Optionally do a
ridge-regularized least-squares solve if columns are non-orthonormal.
}
