% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_population.R
\name{calc_population}
\alias{calc_population}
\title{Multi-fleet, multi-area, multi-stock population dynamics model}
\usage{
calc_population(
  ny = 10,
  nm = 4,
  na = 20,
  nf = 1,
  nr = 4,
  ns = 2,
  initN_ars = array(1, c(na, nr, ns)),
  mov_ymarrs,
  M_yas = array(0.3, c(ny, na, ns)),
  SRR_s = rep("BH", ns),
  sralpha_s = rep(1e+16, ns),
  srbeta_s = rep(1e+16, ns),
  mat_yas = array(1, c(ny, na, ns)),
  fec_yas = array(1, c(ny, na, ns)),
  Rdev_ys = matrix(1, ny, ns),
  m_spawn = 1,
  m_advanceage = 1,
  delta_s = rep(0, ns),
  natal_rs = matrix(1, nr, ns),
  recdist_rs = matrix(1/nr, nr, ns),
  fwt_ymafs = array(1, c(ny, nm, na, nf, ns)),
  q_fs = matrix(1, nf, ns),
  sel_ymafs = array(1, c(ny, nm, na, nf, ns)),
  condition = c("F", "catch"),
  F_ymfr = array(0, c(ny, nm, nf, nr)),
  Cobs_ymfr = array(1e-08, c(ny, nm, nf, nr)),
  Fmax = 2,
  nitF = 5L
)
}
\arguments{
\item{ny}{Integer, number of years for the projection}

\item{nm}{Integer, number of seasons}

\item{na}{Integer, number of age classes}

\item{nf}{Integer, number of fleets}

\item{nr}{Integer, number of regions}

\item{ns}{Integer, number of stocks}

\item{initN_ars}{Abundance in the first year, first season. Array \verb{[a, r, s]}}

\item{mov_ymarrs}{Movement array \verb{[y, m, a, r, r, s]}. If missing, uses a diagonal matrix (no movement among areas).}

\item{M_yas}{Natural mortality (per year). Array \verb{[y, a, s]}}

\item{SRR_s}{Character vector by \code{s} for the stock recruit relationship. See \code{\link[=calc_recruitment]{calc_recruitment()}} for options}

\item{sralpha_s}{Numeric vector by \code{s} for the stock recruit alpha parameter}

\item{srbeta_s}{Numeric vector by \code{s} for the stock recruit beta parameter}

\item{mat_yas}{Maturity ogive. Array \verb{[y, a, s]}}

\item{fec_yas}{Fecundity schedule (spawning output of mature individuals). Array \verb{[y, a, s]}}

\item{Rdev_ys}{Recruitment deviations. Matrix \verb{[y, s]}}

\item{m_spawn}{Integer, season of spawning}

\item{m_advanceage}{Integer, season at which to advance integer year age classes}

\item{delta_s}{Numeric vector by \code{s}. Fraction of season that elapses when spawning occurs, e.g., midseason spawning when \code{delta_s = 0.5}.}

\item{natal_rs}{Matrix \verb{[r, s]}. The fraction of the mature stock \code{s} in region \code{r} that spawns at
time of spawning. See example in \linkS4class{Dstock}.}

\item{recdist_rs}{Matrix \verb{[r, s]}. The fraction of the incoming recruitment of stock \code{s} that settles in region \code{r}.}

\item{fwt_ymafs}{Fishery weight at age. Array \verb{[y, m, a, f, s]}}

\item{q_fs}{Relative catchability of stock \code{s} for fleet \code{f}. Defaults to 1 if missing. Matrix \verb{[f, s]}}

\item{sel_ymafs}{Fishery selectivity. Array \verb{[y, m, a, f, s]}}

\item{condition}{Whether the fishing mortality is conditioned on the catch or specified F argument.}

\item{F_ymfr}{Fishing mortality (per season). Array \verb{[y, m, f, r]}. Only used if \code{condition = "F"}.}

\item{Cobs_ymfr}{Fishery catch (weight). Array \verb{[y, m, f, r]}. Only used if \code{condition = "catch"} to solve for F (see \code{\link[=calc_F]{calc_F()}}).}

\item{Fmax}{Numeric, the maximum Findex value}

\item{nitF}{Integer, number of iterations for the Newton-Raphson routine}
}
\value{
A named list containing:
\itemize{
\item \code{N_ymars} Stock abundance
\item \code{F_ymars} Fishing mortality (summed across fleets)
\item \code{F_ymfr} Fishing mortality (by fleet and region)
\item \code{Z_ymars} Total mortality
\item \code{F_ymafrs} Fishing mortality (disaggregated by fleet)
\item \code{CN_ymafrs} Catch at age (abundance)
\item \code{CB_ymfrs} Fishery catch (weight)
\item \code{VB_ymfrs} Vulnerable biomass available to the fishing fleets
\item \code{Nsp_yars} Spawning abundance (in the spawning season)
\item \code{Npsp_yars} Potentail spawners, mature animals in the spawning season that do not spawn if outside natal regions
\item \code{S_yrs} Spawning output
\item \code{R_ys} Recruitment
\item \code{penalty} Numeric quadratic penalty if apical fishing mortality (by fleet) exceeds \code{Fmax}. See \code{\link[=calc_F]{calc_F()}}.
}
}
\description{
Project age-structured populations forward in time. Also used by \verb{[calc_phi_project()]} to calculate
equilibrium abundance and biomass for which there is no analytic solution
due to seasonal movement.
}
\examples{
unfished_pop <- calc_population()
}
