% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrbin.R
\name{unitVarianceScaling}
\alias{unitVarianceScaling}
\title{A function for scaling to unit variance.}
\usage{
unitVarianceScaling(mrbinResults, verbose = TRUE, errorsAsWarnings = FALSE)
}
\arguments{
\item{mrbinResults}{An mrbin object}

\item{verbose}{Should a summary be printed?}

\item{errorsAsWarnings}{If TRUE, errors will be turned into warnings. Should be used with care, as errors indicate undocumented changes to the data.}
}
\value{
An invisible mrbin object containing scaled NMR data.
}
\description{
This function performs scaling of binned data to unit variance so that each
bin has variance 1 and mean 0. This is
rarely necessary, but might be advantageous, e.g. in artificial neural networks.
}
\examples{
resetEnv()#clean up previous data from the package environment 
results<-mrbin(silent=TRUE,setDefault=TRUE,parameters=list(dimension="1D",
         binwidth1D=0.05,PQNScaling="No",PCA="No",logTrafo="No",
         NMRvendor="mrbin",
         example=TRUE,#only used for the package examples
         NMRfolders=c(system.file("extdata/1.mr1",package="mrbin"),
                      system.file("extdata/2.mr1",package="mrbin"),
                      system.file("extdata/3.mr1",package="mrbin"))))
results<-unitVarianceScaling(results)
}
