% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrFlashlight.R
\name{mrFlashlight}
\alias{mrFlashlight}
\title{Convert mrIML object into a \pkg{flashlight} object}
\usage{
mrFlashlight(mrIMLobj, response = "multi", index = 1, predict_function = NULL)
}
\arguments{
\item{mrIMLobj}{A list object output by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.}

\item{response}{A character string indicating the type of response:
\code{"single"} selects one response (indicated by \code{index}) and \code{"multi"} selects
all responses.}

\item{index}{A numeric value used when \code{response} is \code{"single"} to select
which response column in the data to create a flashlight object for.}

\item{predict_function}{A function specifying a user-defined prediction
function (optional).}
}
\value{
A flashlight or multi-flashlight object.
}
\description{
A wrapper function around \code{\link[flashlight:flashlight]{flashlight::flashlight()}} to run multi-response
model-agnostic interpretable machine learning analyses. The output can be
interrogated using the core functionality of \pkg{flashlight}: see
\code{vignette("flashlight", package = "flashlight")}.
}
\examples{
library(flashlight)
library(ggplot2)

mrIML_rf <- mrIML::mrIML_bird_parasites_RF

fl <- mrFlashlight(
  mrIML_rf,
  response = "multi",
  index = 1
)

# Performance comparison
fl \%>\%
  light_performance(
    metrics = list(`ROC AUC` = MetricsWeighted::AUC)
  ) \%>\%
  plot() +
  ylim(0, 1)

# Partial dependence curves
fl \%>\%
  light_profile(data = cbind(mrIML_rf$Data$X, mrIML_rf$Data$Y), "scale.prop.zos") \%>\%
  plot()

# Two-way partial dependence
fl \%>\%
  light_profile2d(c("scale.prop.zos", "Plas")) \%>\%
  plot()
}
