% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mrCovar.R
\name{mrCovar}
\alias{mrCovar}
\title{Investigate partial dependencies of a covariate for mrIML JSDMs (Joint
Species Distribution Models)}
\usage{
mrCovar(mrIMLobj, var, sdthresh = 0.05, ...)
}
\arguments{
\item{mrIMLobj}{A list object output by \code{\link[=mrIMLpredicts]{mrIMLpredicts()}}.}

\item{var}{The variable of interest for calculating the profile.}

\item{sdthresh}{The standard deviation threshold for filtering taxa
(default: 0.05).}

\item{...}{Arguments passed to \code{\link[flashlight:light_profile]{flashlight::light_profile()}}}
}
\value{
A list of figures:
\itemize{
\item \verb{$partial_dep_curves}: The covariate partial dependence profiles for those
models that meet the \code{sdthresh} requirement.
\item \verb{$partial_dep_avg}: The average partial dependence profile for all models.
All individual model partial dependence profiles are silhouetted in the
background.
\item \verb{$partial_dep_diff}: The distribution of the rates of change in probability
for the specified variable (the derivatives of the PD curves). Useful to
identify key threshold values in the variable.
}
}
\description{
This function is a wrapper around \code{\link[=mrFlashlight]{mrFlashlight()}} that plots the covariate
partial dependencies for a specified environmental/host variable. It also
filters the taxa based on standard deviation thresholds.
}
\examples{
mrIML_rf <-  mrIML::mrIML_bird_parasites_RF

covar_results <- mrIML_rf \%>\%
  mrCovar(var = "scale.prop.zos", sdthresh = 0.05)

}
