% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mid_breakdown.R
\name{mid.breakdown}
\alias{mid.breakdown}
\title{Calculate MID Breakdowns}
\usage{
mid.breakdown(object, data = NULL, row = NULL, sort = TRUE)
}
\arguments{
\item{object}{a "mid" object.}

\item{data}{a data frame containing one or more observations for which to calculate the MID breakdown. If not provided, data is automatically extracted based on the function call.}

\item{row}{an optional numeric value or character string specifying the row of \code{data} to be used for the breakdown. If \code{NULL}, and the \code{data} contains two or more observations, only the first observation is used.}

\item{sort}{logical. If \code{TRUE}, the output data frame is sorted by the absolute contribution of each effect.}
}
\value{
\code{mid.breakdown()} returns an object of class "mid.breakdown". This is a list with the following components:
\item{breakdown}{a data frame containing the breakdown of the prediction.}
\item{data}{the data frame containing the predictor variable values used for the prediction.}
\item{intercept}{the intercept of the MID model.}
\item{prediction}{the predicted value from the MID model.}
}
\description{
\code{mid.breakdown()} calculates the contribution of each component function of a fitted MID model to a single prediction.
It breaks down the total prediction into the effects of the intercept, main effects, and interactions.
}
\details{
\code{mid.breakdown()} is a method for local interpretability.
For a given observation, it provides a clear answer to the question, "How much did each component of the MID model contribute to the final prediction?"

The function calculates the value of each term in the MID model's additive structure for the specified observation.
The total prediction is the sum of these individual contributions.
The prediction, denoted \eqn{\mathcal{F}(\mathbf{x})}, is decomposed as:
\deqn{\mathcal{F}(\mathbf{x}) = f_\phi + \sum_{j} f_{j}(x_j) + \sum_{j<k} f_{jk}(x_j, x_k)}

The output data frame itemizes the numerical value of each main effect
(\eqn{f_{j}(x_j)}) and interaction effect (\eqn{f_{jk}(x_j, x_k)}),
along with the intercept (\eqn{f_\phi}). This makes the prediction transparent
and easy to understand.
}
\examples{
data(airquality, package = "datasets")
mid <- interpret(Ozone ~ .^2, data = airquality, lambda = 1)

# Calculate the breakdown for the first observation in the data
mbd <- mid.breakdown(mid, data = airquality, row = 1)
print(mbd)

# Calculate the breakdown for the third observation in the data
mbd <- mid.breakdown(mid, data = airquality, row = 3)
print(mbd)
}
\seealso{
\code{\link{interpret}}, \code{\link{plot.mid.breakdown}}, \code{\link{ggmid.mid.breakdown}}
}
