#' Computes prediction 
#' @description 
#' Similar to other predict methods, this functions predicts fitted values from a fitted sglfit object.
#' @details 
#' \code{s} is the new vector at which predictions are to be made. If s is not in the lambda sequence used for fitting the model, the predict function will use linear interpolation to make predictions. The new values are interpolated using a fraction of predicted values from both left and right \eqn{lambda} indices.
#' @param object fitted \code{\link{fa.sglfit}} model object.
#' @param newx matrix of new values for x at which predictions are to be made. NOTE: \code{newx} must be a matrix, predict function does not accept a vector or other formats of newx. In addition, note that x should be binded with columns of out-of-sample factors. 
#' @param s choose between 'lam.min' and 'lam.1se'.
#' @param type type of prediction required. Only response is available. Gives predicted response for regression problems.
#' @param method choose between 'single', 'pooled', and 'fe'. 
#' @param ... Not used. Other arguments to predict.
#' @return The object returned depends on type.
#' @export predict.fa.sglfit
predict.fa.sglfit <- function(object, newx, s = c("lam.min","lam.1se"), type = c("response"), ...) {
  type <- match.arg(type)
  s <- match.arg(s)
  if (s == "lam.min") {
    object <- object$cv.fit$lam.min
  }
  if (s == "lam.1se") {
    object <- object$cv.fit$lam.1se
  }
  b0 <- t(as.matrix(object$b0))
  rownames(b0) <- "(Intercept)"
  nbeta <- c(b0, object$beta)
  if (is.null(dim(newx)[1])){
    nfit <- c(1, newx) %*% nbeta
  } else {
    nfit <- cbind(rep(1, times = dim(newx)[1]), newx) %*% nbeta
  }
  nfit
} 