% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transform.R
\name{transform_log}
\alias{transform_log}
\title{Transforms the intensities by calculating their log}
\usage{
transform_log(data, base = 10)
}
\arguments{
\item{data}{A tidy tibble created by \code{\link[metamorphr]{read_featuretable}}.}

\item{base}{Which base should be used for the log-transformation. The default (10) means that log10 values of the intensities are calculated.}
}
\value{
A tibble with log-transformed intensities.
}
\description{
Log-transforms intensities. The default (base = 10) calculates the log10.
This transformation can help reduce heteroscedasticity. See references for more information.
}
\examples{
toy_metaboscape \%>\%
  impute_lod() \%>\%
  transform_log()
}
\references{
\itemize{
\item R. A. Van Den Berg, H. C. Hoefsloot, J. A. Westerhuis, A. K. Smilde, M. J. Van Der Werf, \emph{BMC Genomics} \strong{2006}, \emph{7}, 142, DOI 10.1186/1471-2164-7-142.
}
}
