% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildHeatmap.R
\name{BuildHeatmap}
\alias{BuildHeatmap}
\title{BuildHeatmap}
\usage{
BuildHeatmap(
  metaDeconfOutput,
  q_cutoff = 0.1,
  d_cutoff = 0.01,
  cuneiform = FALSE,
  coloring = 0,
  showConfounded = TRUE,
  intermedData = FALSE,
  featureNames = NULL,
  metaVariableNames = NULL,
  d_range = "full",
  d_col = c("blue", "white", "red"),
  keepMeta = NULL,
  keepFeature = NULL,
  trusted = c("OK_sd", "OK_nc", "OK_d", "AD"),
  tileBordCol = "black",
  reOrder = "both",
  plotPartial = "Ds",
  starSize = 2,
  starNudge_y = 0
)
}
\arguments{
\item{metaDeconfOutput}{output of a metadeconfound run}

\item{q_cutoff}{optional FDR-value cutoff used to remove
low-significance entries from data}

\item{d_cutoff}{optional effect size cutoff used to remove
low effect size entries from data}

\item{cuneiform}{optional logical parameter,
plot cuneiform instead of heatmap when cuneiform = TRUE}

\item{coloring}{optional, can be 0,1,2;
0: color all tiles according to effectsize ;
1: don't color not significant tiles
2: like 1 but also don't color confounded signal tiles}

\item{showConfounded}{optional logical parameter;
set to FALSE to remove significance markers from confounded signals}

\item{intermedData}{only return intermediate data for plotting, default = FALSE}

\item{featureNames}{optional two-column-dataframe containing corresponding
"human-readable" names to the "machine-readable" feature names used as
row.names in metaDeconfOutput. These human readable
names will be displayed in the final plot. First column: machine-readable,
second column: human-readable.}

\item{metaVariableNames}{optional two-column-dataframe containing
corresponding  "human-readable" names to the "machine-readable" metadata
names used as column names in metaDeconfOutput. These human readable
names will be displayed in the final plot. First column: machine-readable,
second column: human-readable.}

\item{d_range}{range of effect size colors shown; "full": (default) range from
-1 to +1 (best for comparability between multiple plots);
"fit": range reduced according to maximum and minimum effect size
present in resulting plot (better color resolution for weaker effects)}

\item{d_col}{set color range for effect size as c(minimum, middle, maximum),
default c("red", "white", "blue")}

\item{keepMeta}{character vector of metavariable names
(corresponding to names in metaDeconfOutput), that should be shown in
resulting plot, even when they have no associations
passing d_cutoff and q_cutoff}

\item{keepFeature}{character vector of metavariable names
(corresponding to names in metaDeconfOutput), that should be shown in
resulting plot, even when they have no associations
passing d_cutoff and q_cutoff}

\item{trusted}{character vector of confounding status labels to be treated
as trustworthy, not-confounded signal. default = c("OK_sd", "OK_nc", "OK_d", "AD")}

\item{tileBordCol}{tile border color of  heatmap tiles, default: "black"}

\item{reOrder}{reorder features and/or metadata? possible options: c("both",
"feat", "meta", "none"), default: "both"}

\item{plotPartial}{choose which effect site should be plotted.
options: c("Ds", "partial", "partialRel, partialNorm"), default: "Ds"}

\item{starSize}{size of asterisks/circles in resulting heatmap, default: 2}

\item{starNudge_y}{nudge y-axis position of asterisks/circles in
resulting heatmap, default: 0}
}
\value{
ggplot2 object
}
\description{
BuildHeatmap summarizes \link[metadeconfoundR]{MetaDeconfound} output in a heatmap or cuneiform plot
}
\details{
for more details and explanations please see the package vignette.
}
\examples{
data(reduced_feature)
data(metaMatMetformin)
\donttest{
example_output <- MetaDeconfound(featureMat = reduced_feature,
                                  metaMat = metaMatMetformin,
                                  logLevel = "ERROR")

plotObject <- BuildHeatmap(example_output)

alternativePlot <- BuildHeatmap(example_output, coloring = 2, showConfounded = FALSE)
}

}
