% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_step_comma.R
\name{process_step_comma}
\alias{process_step_comma}
\title{Process Comma-Separated KOs with Specified Scaling Method}
\usage{
process_step_comma(
  module_abundance,
  KOs = c("K14126,K14127,K14128"),
  aggregrate_rowname,
  step_count = 1,
  comma_scale_method
)
}
\arguments{
\item{module_abundance}{Data frame containing KO abundance data with required columns:
Orthology_Entry, Module_Entry, Definition}

\item{KOs}{Character vector of comma-separated KO IDs (default: "K14126,K14127,K14128")}

\item{aggregrate_rowname}{Base name for row aggregation (default: 'step_1')}

\item{step_count}{Processing step counter (default: 1)}

\item{comma_scale_method}{Scaling method for comma-separated KOs ("sum" or "max")}
}
\value{
List containing:
- abundance_table: Processed data with aggregated values
- step_count: Updated step counter
- abundance_log: log
}
\description{
Handles comma-separated KOs by applying the specified scaling method (sum or max).
Processes multiple KOs separated by commas and aggregates them into a single row.
}
