% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/holey_line.r
\name{holey_line}
\alias{holey_line}
\title{holey_line .}
\usage{
holey_line(
  unit_len,
  num_segs,
  which_seg = NULL,
  go_back = FALSE,
  hole_color = NULL,
  hole_arrow = FALSE
)
}
\arguments{
\item{unit_len}{the unit length in graph coordinates. This controls
the width of the \sQuote{holes} in the boundary lines and
generally controls the spacing of mazes.}

\item{num_segs}{the total number of segments. All but one of these,
of length \code{unit_len} will be drawn. The other, randomly
chosen, will be a hole. If \code{num_segs} is one, only a hole is made,
and no line drawn.  If zero or less, no action taken.}

\item{which_seg}{optional numeric indicating which segment should
have the hole. If \code{NULL}, the hole segment is chosen uniformly
at random.}

\item{go_back}{whether to return the turtle to starting position
when the line has been drawn.}

\item{hole_color}{the color to plot the \sQuote{hole}. A 
\code{NULL} value corresponds to no drawn hole. 
See the \code{\link[grDevices]{colors}} function for
acceptable values.}

\item{hole_arrow}{a boolean or indicating whether
to draw a perpendicular arrow at a hole.}
}
\value{
Returns the \code{which_seg} variable, the location of the hole, though typically
the function is called for side effects only.
}
\description{
Draws a line with a randomly selected \sQuote{hole} in it.
}
\details{
This function is the workhorse of drawing mazes, as it
creates a maze wall with a single hole in it.
}
\examples{

library(TurtleGraphics)
turtle_init(1000,1000,mode='clip')
turtle_hide()
y <- holey_line(unit_len=20, num_segs=15)

turtle_right(90)
y <- holey_line(unit_len=20, num_segs=10,hole_arrow=TRUE)

}
\author{
Steven E. Pav \email{shabbychef@gmail.com}
}
\keyword{plotting}
