% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regional_comparison_functions.R
\name{compare_regions}
\alias{compare_regions}
\title{Compare Multiple Regions}
\usage{
compare_regions(
  regions,
  scale = "county",
  year = 2016,
  nutrients = "nitrogen",
  include_wwtp = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{regions}{Named list of state vectors, or character vector of built-in region names}

\item{scale}{Spatial scale}

\item{year}{Year to analyze}

\item{nutrients}{Nutrients to analyze}

\item{include_wwtp}{Include WWTP?}

\item{verbose}{Show messages?}
}
\value{
List with regional comparison results
}
\description{
Compare Multiple Regions
}
\examples{
\dontrun{
# Compare built-in regions
comparison <- compare_regions(
  regions = c("corn_belt", "dairy_belt"),
  scale = "county",
  year = 2016,
  nutrients = "nitrogen"
)

# Compare custom regions
comparison <- compare_regions(
  regions = list(
    "Upper Midwest" = c("WI", "MN", "MI"),
    "Lower Midwest" = c("IL", "IN", "OH")
  ),
  scale = "county",
  year = 2016
)

# View comparison
print(comparison$summary)
comparison$plots$bar_chart
}
}
