% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_expected.R
\name{getExpectedMeasIntervals}
\alias{getExpectedMeasIntervals}
\title{Compute credible intervals for expected measurements}
\usage{
getExpectedMeasIntervals(expectedMeas, mass = 0.9, method = c("eti", "hdi"))
}
\arguments{
\item{expectedMeas}{A \code{data.table} of expected measurements for posterior
samples, as returned by \code{\link[=getExpectedMeas]{getExpectedMeas()}}.}

\item{mass}{Number between 0 and 1 indicating the probability mass for which
to calculate the intervals.}

\item{method}{String indicating the type of interval: 'eti' for equal-tailed
using \code{\link[stats:quantile]{stats::quantile()}}, or 'hdi' for highest density using
\code{\link[HDInterval:hdi]{HDInterval::hdi()}}.}
}
\value{
A \code{data.table} containing lower and upper bounds of the expected
measurement for each combination of feature, time, and possibly condition
and covariate.
}
\description{
This functions uses posterior samples to quantify uncertainty in the
expected measurements from fitted models.
}
\examples{
library('data.table')

y = GSE34018$y
metadata = GSE34018$metadata

fit = getModelFit(y, metadata)
fit = getPosteriorFit(fit)
fit = getPosteriorSamples(fit, nPosteriorSamples = 10L)

measFitSamps = getExpectedMeas(
  fit, times = seq(0, 24, 0.5), fitType = 'posterior_samples',
  features = c('13170', '12686'))
measFitInts = getExpectedMeasIntervals(measFitSamps)
}
\seealso{
\code{\link[=getExpectedMeas]{getExpectedMeas()}}, \code{\link[=getStatsIntervals]{getStatsIntervals()}}
}
