% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licoread_to_fluxible.R
\name{licoread_to_fluxible}
\alias{licoread_to_fluxible}
\title{selects the focus gas and makes a df to use in \link[fluxible]{fluxible}}
\usage{
licoread_to_fluxible(
  df,
  focus_gas,
  datetime_col,
  id_cols = c("File Name", "Obs#"),
  file_type = "auto",
  file_type_list = c("82z", "81x", "auto")
)
}
\arguments{
\item{df}{input dataframe from \link[licoread:licoread]{licoread}}

\item{focus_gas}{gas to select}

\item{datetime_col}{column containing datetime information if date and time
are in two different columns, provide a character vector of the form
c("date", "time")}

\item{id_cols}{columns to identify unique fluxes}

\item{file_type}{type of file (82z or 81x). If "auto" (default), the
function will try to detect it by itself.}

\item{file_type_list}{list of file types}
}
\value{
an unnested df with only the selected gas
}
\description{
selects the focus gas and checks the columns needed for the
\link[fluxible]{fluxible} workflow
}
\examples{
path_82z <- system.file("extdata/82z", package = "licoread")
gas_df_82z <- licoread(path_82z)
licoread_to_fluxible(gas_df_82z, "LI-7810_CH4_DRY",
datetime_col = c("LI-8250_DATE", "LI-8250_TIME"))
}
