% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lavaanHelperFunctions.R
\name{getLavaanParameters}
\alias{getLavaanParameters}
\title{getLavaanParameters}
\usage{
getLavaanParameters(lavaanModel, removeDuplicates = TRUE)
}
\arguments{
\item{lavaanModel}{model of class lavaan}

\item{removeDuplicates}{should duplicated parameters be removed?}
}
\value{
returns a labeled vector with parameters from lavaan
}
\description{
helper function: returns a labeled vector with parameters from lavaan
}
\examples{
library(lessSEM)

dataset <- simulateExampleData()

lavaanSyntax <- "
f =~ l1*y1 + l2*y2 + l3*y3 + l4*y4 + l5*y5 +
     l6*y6 + l7*y7 + l8*y8 + l9*y9 + l10*y10 +
     l11*y11 + l12*y12 + l13*y13 + l14*y14 + l15*y15
f ~~ 1*f
"

lavaanModel <- lavaan::sem(lavaanSyntax,
                           data = dataset,
                           meanstructure = TRUE,
                           std.lv = TRUE)
getLavaanParameters(lavaanModel)                       
}
