% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UpdateKlass.R
\name{update_klass}
\alias{update_klass}
\title{Update multiple Klass codes to a desired date.}
\usage{
update_klass(
  codes,
  dates = NA,
  classification = NULL,
  date = NULL,
  graph = klass_graph(classification, date),
  output = "code",
  report = FALSE,
  combine = TRUE
)
}
\arguments{
\item{codes}{Codes to be updated.}

\item{dates}{Optional. Can be used to specify what date each of the codes was
valid in. Supply a character vector of either length 1 to specify the same
valid date for all codes, or of the same length as \code{codes} to specify
valid dates for each code. The character vector(s) should have a format
coercible by \code{\link[base]{as.Date}}, e.g. \code{YYYY-MM-DD}. The
function will return an error if a code was not valid at the specified
date.}

\item{classification}{The ID of the desired classification.}

\item{date}{Optional. Can be used to specify the date the codes should be
updated to, e.g. if you have codes that are valid in year \code{T}, but
want to change the codes to the corresponding version in year \code{T-1}.
If unspecified (the default), the function will update codes to the most
recent version.}

\item{graph}{Optional. A graph object generated by \code{\link{klass_graph}}.
If you're making multiple calls to [update_klass], you can save some time by
generating the graph beforehand and reusing it for each call to
[update_klass] with this parameter. If providing the graph directly, you do
not need to provide the \code{classification} and \code{date} parameters.}

\item{output}{Either a character vector, containing one or more of the items
  in the list below, or \code{TRUE} to include all columns.

  \describe{
   \item{\code{"code"}}{The Klass code.}
   \item{\code{"name"}}{The Klass name.}
   \item{\code{"validFrom"}}{The date that the code is valid from.}
   \item{\code{"validTo"}}{The date that the code is valid to.}
   \item{\code{"split"}}{Logical: Does the code split into two or more codes?}
   \item{\code{"combined"}}{Logical: Does two or more codes become this code?}
   \item{\code{"nextCode"}}{If \code{split == FALSE}, gives the code this code changed into. \code{NA} otherwise.}
  }}

\item{report}{\code{TRUE} or \code{FALSE}. See the return section.}

\item{combine}{\code{TRUE} or \code{FALSE}. See the return section.}
}
\value{
If \code{output = "code"}, a vector of length \code{length(codes)}
  containing either a code if the update is successful or \code{NA} if the
  code has been split. If \code{combine = FALSE}, a code being combined with
  another code will also return \code{NA}.

  If \code{output == TRUE}, a list of length \code{length(codes)} containing
  \code{data.frame}s detailing the codes visited through the node search. The
  tables have the following columns.

  ---

  If \code{report == TRUE} and \code{length(output) > 1 | TRUE}, the result
  will be a list of \code{data.frame}s with number of rows equal to the
  number of codes in the sequence of changes between the input codes and
  output codes. The columns in the \code{data.frame}s are specified with
  \code{output}.

  If \code{report == TRUE} and \code{length(output) == 1}, the result will be
  a list of character vectors with length equal to the number of codes in the
  sequence of changes between the input code and output code. The contents of
  the character vectors is specified with \code{output}.

  If \code{report == FALSE} and \code{length(output) > 1 | TRUE} the result
  will be a list of \code{data.frame}s with one row representing the last
  code in the change sequence and columns specified by \code{output}. If a
  code has been split, the result will be \code{NA}. If \code{combine ==
  FALSE} and a code is the result of a combination of codes, the result will
  be \code{NA}.

  If \code{report == FALSE} and \code{length(output) == 1}, the result will
  be a character vector containing information about the updated codes
  specified by \code{output}. If a code has been split, the result will be
  \code{NA}. If \code{combine == FALSE} and a code is the result of a
  combination of codes, the result will be \code{NA}.
}
\description{
Update multiple Klass codes to a desired date.
}
\examples{
library(klassR)
codes <- get_klass(131, date = "2020-01-01")[["code"]]

\dontrun{
updated_codes <- update_klass(codes,
  dates = "2020-01-01",
  classification = 131
)
}

}
