% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losses.R
\name{loss_kl_divergence}
\alias{loss_kl_divergence}
\title{Computes Kullback-Leibler divergence loss between \code{y_true} & \code{y_pred}.}
\usage{
loss_kl_divergence(
  y_true,
  y_pred,
  ...,
  reduction = "sum_over_batch_size",
  name = "kl_divergence",
  dtype = NULL
)
}
\arguments{
\item{y_true}{Tensor of true targets.}

\item{y_pred}{Tensor of predicted targets.}

\item{...}{For forward/backward compatability.}

\item{reduction}{Type of reduction to apply to the loss. In almost all cases
this should be \code{"sum_over_batch_size"}. Supported options are
\code{"sum"}, \code{"sum_over_batch_size"}, \code{"mean"},
\code{"mean_with_sample_weight"} or \code{NULL}. \code{"sum"} sums the loss,
\code{"sum_over_batch_size"} and \code{"mean"} sum the loss and divide by the
sample size, and \code{"mean_with_sample_weight"} sums the loss and
divides by the sum of the sample weights. \code{"none"} and \code{NULL}
perform no aggregation. Defaults to \code{"sum_over_batch_size"}.}

\item{name}{Optional name for the loss instance.}

\item{dtype}{The dtype of the loss's computations. Defaults to \code{NULL}, which
means using \code{config_floatx()}. \code{config_floatx()} is a
\code{"float32"} unless set to different value
(via \code{config_set_floatx()}). If a \code{keras$DTypePolicy} is
provided, then the \code{compute_dtype} will be utilized.}
}
\value{
KL Divergence loss values with shape = \verb{[batch_size, d0, .. dN-1]}.
}
\description{
Formula:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{loss <- y_true * log(y_true / y_pred)
}\if{html}{\out{</div>}}

\code{y_true} and \code{y_pred} are expected to be probability
distributions, with values between 0 and 1. They will get
clipped to the \verb{[0, 1]} range.
}
\section{Examples}{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{y_true <- random_uniform(c(2, 3), 0, 2)
y_pred <- random_uniform(c(2,3))
loss <- loss_kl_divergence(y_true, y_pred)
loss
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{## tf.Tensor([ 2.4290292 -0.6284211], shape=(2), dtype=float32)

}\if{html}{\out{</div>}}
}

\seealso{
\itemize{
\item \url{https://keras.io/api/losses/probabilistic_losses#kldivergence-class}
}

Other losses: \cr
\code{\link{Loss}()} \cr
\code{\link{loss_binary_crossentropy}()} \cr
\code{\link{loss_binary_focal_crossentropy}()} \cr
\code{\link{loss_categorical_crossentropy}()} \cr
\code{\link{loss_categorical_focal_crossentropy}()} \cr
\code{\link{loss_categorical_hinge}()} \cr
\code{\link{loss_circle}()} \cr
\code{\link{loss_cosine_similarity}()} \cr
\code{\link{loss_ctc}()} \cr
\code{\link{loss_dice}()} \cr
\code{\link{loss_hinge}()} \cr
\code{\link{loss_huber}()} \cr
\code{\link{loss_log_cosh}()} \cr
\code{\link{loss_mean_absolute_error}()} \cr
\code{\link{loss_mean_absolute_percentage_error}()} \cr
\code{\link{loss_mean_squared_error}()} \cr
\code{\link{loss_mean_squared_logarithmic_error}()} \cr
\code{\link{loss_poisson}()} \cr
\code{\link{loss_sparse_categorical_crossentropy}()} \cr
\code{\link{loss_squared_hinge}()} \cr
\code{\link{loss_tversky}()} \cr
\code{\link{metric_binary_crossentropy}()} \cr
\code{\link{metric_binary_focal_crossentropy}()} \cr
\code{\link{metric_categorical_crossentropy}()} \cr
\code{\link{metric_categorical_focal_crossentropy}()} \cr
\code{\link{metric_categorical_hinge}()} \cr
\code{\link{metric_hinge}()} \cr
\code{\link{metric_huber}()} \cr
\code{\link{metric_kl_divergence}()} \cr
\code{\link{metric_log_cosh}()} \cr
\code{\link{metric_mean_absolute_error}()} \cr
\code{\link{metric_mean_absolute_percentage_error}()} \cr
\code{\link{metric_mean_squared_error}()} \cr
\code{\link{metric_mean_squared_logarithmic_error}()} \cr
\code{\link{metric_poisson}()} \cr
\code{\link{metric_sparse_categorical_crossentropy}()} \cr
\code{\link{metric_squared_hinge}()} \cr
}
\concept{losses}
