% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{update.fitted_dlm}
\alias{update.fitted_dlm}
\title{update.fitted_dlm}
\usage{
\method{update}{fitted_dlm}(object, ...)
}
\arguments{
\item{object}{fitted_dlm: The fitted model to be updated.}

\item{...}{Extra variables necessary for updating (covariates, observed values, etc.).}
}
\value{
A fitted_dlm object.
}
\description{
update.fitted_dlm
}
\details{
If an a covariate is necessary for updating, it should be passed as a named argument. Its name must follow this structure: <block name>.Covariate<.index>. If there is only one pulse in the associated block the index is omitted.
If an a pulse is necessary for updating, it should be passed as a named argument. Its name must follow this structure: <block name>.Pulse<.index>. If there is only one pulse in the associated block the index is omitted.
If an offset is necessary for updating, it should be passed along with the observed data. See example.
}
\examples{

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

# Only first 100 observations (for the sake of the example)
outcome <- Poisson(lambda = "rate", data = c(AirPassengers)[1:100])

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)

updated.fit <- update(fitted.data, AirPassengers = list(data = c(AirPassengers)[101:144]))
# If a offset was present, the user should pass its value when updating
# updated.fit=update(fitted.data,
#                     AirPassengers=list(
#                      data=c(AirPassengers)[101:144],
#                      offset= ... ))

}
\seealso{
Other auxiliary functions for fitted_dlm objects: 
\code{\link{coef.fitted_dlm}()},
\code{\link{eval_dlm_norm_const}()},
\code{\link{fit_model}()},
\code{\link{forecast.fitted_dlm}()},
\code{\link{kdglm}()},
\code{\link{simulate.fitted_dlm}()},
\code{\link{smoothing}()}
}
\concept{auxiliary functions for fitted_dlm objects}
