#' @title Prepare Data for Weighted CIF (Legacy Wrapper)
#' @description Convenience wrapper that mirrors the original Part II data
#'   preparation workflow for weighted restricted mean analyses. The function now
#'   delegates to \code{\link{prep_data_weighted_cif2}} to provide consistent checks
#'   and support for arbitrary ordinal state definitions.
#' @inheritParams prep_data_weighted_cif2
#' @return See \code{\link{prep_data_weighted_cif2}}.
#' @export
prep_data_weighted_cif <- function(
    data_main,
    data_long,

    wID_main              = "USUBJID",
    wTimeToRecovery_main  = "TTRECOV",
    wTimeToDeath_main     = "TTDEATH",
    wRecov_Censoring_main = "RECCNSR",
    wDeath_Censoring_main = "DTHCNSR",
    wBaselineScore_main   = "ordscr_bs",
    wTreatment_main       = "trt",

    wID_long              = "USUBJID",
    wADY_long             = "ADYC",
    wScore_long           = "ORDSCOR",

    wStates_death         = c(4,5,6,7),
    wWeights_death        = c(2,1.5,1,0.5),
    wStates_discharge     = c(4,5,6,7),
    wWeights_discharge    = c(0.5,1,1.5,2)
){
  prep_data_weighted_cif2(
    data_main = data_main,
    data_long = data_long,
    wID_main = wID_main,
    wTimeToRecovery_main = wTimeToRecovery_main,
    wTimeToDeath_main = wTimeToDeath_main,
    wRecov_Censoring_main = wRecov_Censoring_main,
    wDeath_Censoring_main = wDeath_Censoring_main,
    wBaselineScore_main = wBaselineScore_main,
    wTreatment_main = wTreatment_main,
    wID_long = wID_long,
    wADY_long = wADY_long,
    wScore_long = wScore_long,
    wStates_death = wStates_death,
    wWeights_death = wWeights_death,
    wStates_discharge = wStates_discharge,
    wWeights_discharge = wWeights_discharge
  )
}
