% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{index.coord}
\alias{index.coord}
\title{Linear index in internal vector from pixel coordinates}
\usage{
index.coord(im, coords, outside = "stop")
}
\arguments{
\item{im}{an image}

\item{coords}{a data.frame with values x,y,z (optional), c (optional)}

\item{outside}{what to do if some coordinates are outside the image: "stop" issues error, "NA" replaces invalid coordinates with NAs. Default: "stop".}
}
\value{
a vector of indices (NA if the indices are invalid)
}
\description{
Pixels are stored linearly in (x,y,z,c) order. This function computes the vector index of a pixel given its coordinates
}
\examples{
\dontshow{cimg.limit.openmp()}
im <- as.cimg(function(x,y) x+y,100,100)
px <- index.coord(im,data.frame(x=c(3,3),y=c(1,2)))
im[px] #Values should be 3+1=4, 3+2=5
}
\seealso{
coord.index, the reverse operation
}
\author{
Simon Barthelme
}
