% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/igfetchr.R
\name{ig_search_markets}
\alias{ig_search_markets}
\title{Search markets}
\usage{
ig_search_markets(query, auth, mock_response = NULL)
}
\arguments{
\item{query}{Character. Search string for markets (e.g., "USD/CHF").}

\item{auth}{List. Authentication details from `ig_auth()`, 
including `cst`, `security`, `base_url`, `api_key`, and `acc_number`.}

\item{mock_response}{List or data frame. Optional mock response for testing, bypassing the API call.}
}
\value{
A tibble with market information including epic, instrument name and market status.
}
\description{
Search markets by text query. Returns a tibble of matching markets from the IG API.
}
\examples{
\dontrun{
# Authenticate and search markets
auth <- ig_auth(
  username = "your_username",
  password = "your_password",
  api_key = "your_api_key",
  acc_type = "DEMO",
  acc_number = "ABC123"
)
markets <- ig_search_markets("USD/CHF", auth)
print(markets)

# Using mock response
mock_response <- data.frame(
  epic = "CS.D.USDCHF.MINI.IP",
  instrumentName = "USD/CHF Mini",
  marketStatus = "OPEN"
)
markets <- ig_search_markets("USD/CHF", auth, mock_response = mock_response)
}

}
