% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{import_emulator_from_json}
\alias{import_emulator_from_json}
\title{Import JSON Emulator Data}
\usage{
import_emulator_from_json(filename = NULL, details = NULL)
}
\arguments{
\item{filename}{Either a file location of a saved JSON file, or the string corresponding to it}

\item{details}{Mainly internal; any already reconstructed emulators and their input data}
}
\value{
The emulator objects, as a list.
}
\description{
Given a file containing emulator details, reconstruct a collection of emulators.
}
\details{
For data generated from \code{\link{export_emulator_to_json}} (for example),
emulators are recreated using the specifications therein. For each emulator,
a call is made to \code{\link{emulator_from_data}} with \code{specified_priors}
stipulated (so no retraining is performed, making the reconstruction fast).

The structure of the JSON file used to import is relatively generic, and can
be created outside of this package. For examples of the structure, see the
code given in the companion export function.
}
\seealso{
export_emulator_to_json
}
