% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hill_estimator.R
\name{hill_estimator}
\alias{hill_estimator}
\title{Hill Estimator}
\usage{
hill_estimator(data, k, na.rm = FALSE)
}
\arguments{
\item{data}{A numeric vector of i.i.d. observations.}

\item{k}{An integer specifying the number of top order statistics to use
(the size of the tail). Must be strictly less than the sample size.}

\item{na.rm}{Logical. If \code{TRUE}, missing values (\code{NA}) are removed
before analysis. Defaults to \code{FALSE}.}
}
\value{
A single numeric scalar: Hill estimator calculation of the tail index \eqn{\alpha}.
}
\description{
Hill estimator used to calculate the tail index (alpha) of input data.
}
\details{
\deqn{\hat \alpha_H = \frac{1}{\frac{1}{k} \sum_{i=1}^{k} log(\frac{X_{(i)}}{X_{(k)}})}}

where \eqn{X_{(1)} \ge X_{(2)} \ge \dots \ge X_{(n)}} are the order statistics
of the data (descending order).
}
\examples{

xmin <- 1
alpha <- 2
r <- runif(800, 0, 1)
x <- (xmin * r^(-1/(alpha)))
hill <- hill_estimator(data = x, k = 5)


}
\references{
Hill, B. M. (1975). A Simple General Approach to Inference About the Tail of a Distribution. \emph{The Annals of Statistics}, \bold{3}(5), 1163–1174. \url{http://www.jstor.org/stable/2958370}

Nair, J., Wierman, A., & Zwart, B. (2022). \emph{The Fundamentals of Heavy Tails: Properties, Emergence, and Estimation}. Cambridge University Press. (pp. 203-205) \doi{10.1017/9781009053730}
}
