% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts-random-walk-plot.R
\name{ts_random_walk_plot}
\alias{ts_random_walk_plot}
\title{Auto-Plot a Random Walk}
\usage{
ts_random_walk_plot(.data, .interactive = FALSE)
}
\arguments{
\item{.data}{The data from \code{ts_random_walk()} function.}

\item{.interactive}{The default is FALSE, TRUE will produce an interactive
plotly plot.}
}
\value{
A ggplot2 object or an interactive \code{plotly} plot
}
\description{
Plot a random walk with side-by-side facets showing both the
random variable and cumulative product (random walk path).
}
\details{
This function will take output from the \code{ts_random_walk()} function
and create a side-by-side faceted plot. The left panel shows the random
variable (y) over time, and the right panel shows the cumulative product (cum_y, i.e., the random walk path)
over time. Each simulation run is shown as a separate line. The legend is set
to "none" if the simulation count is higher than 9.
}
\examples{

df <- ts_random_walk(
  .mean = 0,
  .sd = 1,
  .num_walks = 25,
  .periods = 180,
  .initial_value = 100
)

ts_random_walk_plot(df)

}
\seealso{
Other Plot: 
\code{\link{ts_brownian_motion_plot}()},
\code{\link{ts_event_analysis_plot}()},
\code{\link{ts_qq_plot}()},
\code{\link{ts_scedacity_scatter_plot}()}
}
\author{
Steven P. Sanderson II, MPH
}
\concept{Plot}
