% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_commensurate.R
\name{glm.commensurate}
\alias{glm.commensurate}
\title{Posterior of commensurate prior (CP)}
\usage{
glm.commensurate(
  formula,
  family,
  data.list,
  offset.list = NULL,
  beta0.mean = NULL,
  beta0.sd = NULL,
  disp.mean = NULL,
  disp.sd = NULL,
  p.spike = 0.1,
  spike.mean = 200,
  spike.sd = 0.1,
  slab.mean = 0,
  slab.sd = 5,
  get.loglik = FALSE,
  iter_warmup = 1000,
  iter_sampling = 1000,
  chains = 4,
  ...
)
}
\arguments{
\item{formula}{a two-sided formula giving the relationship between the response variable and covariates}

\item{family}{an object of class \code{family}. See \code{\link[stats:family]{?stats::family}}}

\item{data.list}{a list of \code{data.frame}s. The first element in the list is the current data, and the rest
are the historical data sets.}

\item{offset.list}{a list of vectors giving the offsets for each data. The length of \code{offset.list} is equal to
the length of \code{data.list}. The length of each element of \code{offset.list} is equal to the number
of rows in the corresponding element of \code{data.list}. Defaults to a list of vectors of 0s.}

\item{beta0.mean}{a scalar or a vector whose dimension is equal to the number of regression coefficients
giving the mean parameters for the prior on the historical data regression coefficients. If a
scalar is provided, \code{beta0.mean} will be a vector of repeated elements of the given scalar.
Defaults to a vector of 0s.}

\item{beta0.sd}{a scalar or a vector whose dimension is equal to the number of regression coefficients giving
the sd parameters for the prior on the historical data regression coefficients. If a scalar is
provided, same as for \code{beta0.mean}. Defaults to a vector of 10s.}

\item{disp.mean}{a scalar or a vector whose dimension is equal to the number of data sets (including the current
data) giving the location parameters for the half-normal priors on the dispersion parameters.
If a scalar is provided, same as for \code{beta0.mean}. Defaults to a vector of 0s.}

\item{disp.sd}{a scalar or a vector whose dimension is equal to the number of data sets (including the current
data) giving the scale parameters for the half-normal priors on the dispersion parameters. If a
scalar is provided, same as for \code{beta0.mean}. Defaults to a vector of 10s.}

\item{p.spike}{a scalar between 0 and 1 giving the probability of the spike component in spike-and-slab prior
on commensurability parameter \eqn{\tau}. Defaults to 0.1.}

\item{spike.mean}{a scalar giving the location parameter for the half-normal prior (spike component) on \eqn{\tau}.
Defaults to 200.}

\item{spike.sd}{a scalar giving the scale parameter for the half-normal prior (spike component) on \eqn{\tau}.
Defaults to 0.1.}

\item{slab.mean}{a scalar giving the location parameter for the half-normal prior (slab component) on \eqn{\tau}.
Defaults to 0.}

\item{slab.sd}{a scalar giving the scale parameter for the half-normal prior (slab component) on \eqn{\tau}.
Defaults to 5.}

\item{get.loglik}{whether to generate log-likelihood matrix. Defaults to FALSE.}

\item{iter_warmup}{number of warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_warmup} in
\code{sample()} method in cmdstanr package.}

\item{iter_sampling}{number of post-warmup iterations to run per chain. Defaults to 1000. See the argument \code{iter_sampling}
in \code{sample()} method in cmdstanr package.}

\item{chains}{number of Markov chains to run. Defaults to 4. See the argument \code{chains} in \code{sample()} method in
cmdstanr package.}

\item{...}{arguments passed to \code{sample()} method in cmdstanr package (e.g., \code{seed}, \code{refresh}, \code{init}).}
}
\value{
The function returns an object of class \code{draws_df} containing posterior samples. The object has two attributes:

\describe{
\item{data}{a list of variables specified in the data block of the Stan program}

\item{model}{a character string indicating the model name}
}
}
\description{
Sample from the posterior distribution of a GLM using the commensurate prior (CP) by Hobbs et al. (2011) \url{doi:10.1111/j.1541-0420.2011.01564.x}.
}
\details{
The commensurate prior (CP) assumes that the regression coefficients for the current data conditional on those for
the historical data are independent normal distributions with mean equal to the corresponding regression coefficients
for the historical data and variance equal to the inverse of the corresponding elements of a vector of precision
parameters (referred to as the commensurability parameter \eqn{\tau}). We regard \eqn{\tau} as random and elicit
a spike-and-slab prior, which is specified as a mixture of two half-normal priors, on \eqn{\tau}.

The number of current data regression coefficients is assumed to be the same as that of historical data regression
coefficients. The priors on the dispersion parameters (if applicable) for the current and historical data sets are
independent half-normal distributions.
}
\examples{
if (instantiate::stan_cmdstan_exists()) {
  data(actg019)
  data(actg036)
  ## take subset for speed purposes
  actg019 = actg019[1:100, ]
  actg036 = actg036[1:50, ]
  data_list = list(currdata = actg019, histdata = actg036)
  glm.commensurate(
    formula = cd4 ~ treatment + age + race,
    family = poisson(), data.list = data_list,
    p.spike = 0.1,
    chains = 1, iter_warmup = 500, iter_sampling = 1000
  )
}
}
\references{
Hobbs, B. P., Carlin, B. P., Mandrekar, S. J., and Sargent, D. J. (2011). Hierarchical commensurate and power prior models for adaptive incorporation of historical information in clinical trials. Biometrics, 67(3), 1047–1056.
}
