% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hca.R
\name{hca}
\alias{hca}
\title{Generate and Select Groups with Hierarchical Clustering}
\usage{
hca(data, method = "complete", num.groups = 3)
}
\arguments{
\item{data}{Dataset in \code{data.frame} format.}

\item{method}{Method of hierarchical clustering, considering: "ward.D", "ward.D2",
"single", "complete", "average" (UPGMA), "mcquitty" (WPGMA),
"median" (WPGMC) or "centroid" (UPGMC). Default is "complete".}

\item{num.groups}{Number of groups to cut. Default is three.}
}
\value{
A vector of integers, where each element represents the group
assigned to each observation in the original dataset.
}
\description{
Perform hierarchical clustering and generate groups based on
sample dissimilarity using the Euclidean method.
}
\examples{
# Load the required package
library(hclusteasy)


# Read the 'iris' dataset from the package
data("iris_uci")

# Remove column 'Species' from the iris dataset
iris <- iris_uci[, -5]


# Apply hierarchical cluster and selecting groups
g <- hca(iris)

}
