% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_cf_lr.R
\name{hcp_cf_lr}
\alias{hcp_cf_lr}
\title{Change Finder using Linear Regression}
\usage{
hcp_cf_lr(sw_size = 30)
}
\arguments{
\item{sw_size}{Integer. Sliding window size for smoothing/statistics.}
}
\value{
\code{hcp_cf_lr} object.
}
\description{
Change-point detection by modeling residual deviations with linear regression
and applying a second-stage smoothing and thresholding, inspired by
ChangeFinder \url{doi:10.1109/TKDE.2006.1599387}.
}
\examples{
library(daltoolbox)

# Load change-point example data
data(examples_changepoints)

# Use a simple example
dataset <- examples_changepoints$simple
head(dataset)

# Configure ChangeFinder-LR detector
model <- hcp_cf_lr()

# Fit the model
model <- fit(model, dataset$serie)

# Run detection
detection <- detect(model, dataset$serie)

# Show detected change points
print(detection[(detection$event),])

}
