% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_answers.R
\name{combine_answers}
\alias{combine_answers}
\title{Combine answers of a multiple answers question}
\usage{
combine_answers(data, answers, into, value = NULL, sep = NULL)
}
\arguments{
\item{data}{A data frame, data frame extension (e.g. a tibble),
or a survey design object.}

\item{answers}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}>\cr
List of variables
identifying the different answers of the question.}

\item{into}{Names of new variables to create as character vector.}

\item{value}{Value indicating a positive answer. By default, will use the
maximum observed value and will display a message.}

\item{sep}{An optional character string to separate the results and return a
character. If \code{NULL}, return a list column (see examples).}
}
\description{
Considering a multiple answers question coded as several binary variables
(one per item), create a new variable (list column or character) combining
all positive answers. If defined, use variable labels (see examples).
}
\note{
If \code{NA} is observed for at least one item, return \code{NA}.
}
\examples{
d <-
  dplyr::tibble(
    q1a = sample(c("y", "n"), size = 200, replace = TRUE),
    q1b = sample(c("y", "n", "n", NA), size = 200, replace = TRUE),
    q1c = sample(c("y", "y", "n"), size = 200, replace = TRUE),
    q1d = sample("n", size = 200, replace = TRUE)
  )

d |> combine_answers(q1a:q1d, into = "combined")
d |> combine_answers(q1a:q1d, into = "combined", sep = ", ", value = "y")
d |> combine_answers(q1a:q1d, into = "combined", sep = " | ", value = "n")

# works with survey objects
d |>
  srvyr::as_survey() |>
  combine_answers(q1a:q1d, into = "combined")
}
\keyword{manip}
