% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-common.R
\name{time_values_conv}
\alias{time_values_conv}
\alias{gs.time2year}
\alias{gs.time2per}
\alias{gs.time2str}
\title{Time values conversion functions}
\usage{
gs.time2year(ts)

gs.time2per(ts)

gs.time2str(ts, sep = "-")
}
\arguments{
\item{ts}{(mandatory)

Time series (object of class "ts" or "mts").}

\item{sep}{(optional)

String (character constant) specifying the separator to use between the year
and period values.

\strong{Default value} is \code{sep = "-"}.}
}
\value{
\code{\link[=gs.time2year]{gs.time2year()}} returns an integer vector of the "nearest" year (time unit) values. This function is the
equivalent of \code{\link[stats:time]{stats::cycle()}} for time unit values.

\code{\link[=gs.time2per]{gs.time2per()}} returns an integer vector of the period (cycle) values (see \code{\link[stats:time]{stats::cycle()}}).

\code{\link[=gs.time2str]{gs.time2str()}} returns a character vector corresponding to \code{gs.time2year(ts)} if \code{stats::frequency(ts) == 1}
or \code{gs.time2year(ts)} and \code{gs.time2per(ts)} separated with \code{sep} otherwise.
}
\description{
\if{html,text}{(\emph{version française: 
\url{https://StatCan.github.io/gensol-gseries/fr/reference/time_values_conv.html}})}

Time values conversion functions used internally by other gseries functions.
}
\examples{
# Dummy monthly time series 
mth_ts <- ts(rep(NA, 15), start = c(2019, 1), frequency = 12)
mth_ts
gs.time2year(mth_ts)
gs.time2per(mth_ts)
gs.time2str(mth_ts)
gs.time2str(mth_ts, sep = "m")

# Dummy quarterly time series 
qtr_ts <- ts(rep(NA, 5), start = c(2019, 1), frequency = 4)
qtr_ts
gs.time2year(qtr_ts)
gs.time2per(qtr_ts)
gs.time2str(qtr_ts)
gs.time2str(qtr_ts, sep = "q")
}
\seealso{
\code{\link[=ts_to_tsDF]{ts_to_tsDF()}} \code{\link[=ts_to_bmkDF]{ts_to_bmkDF()}} \code{\link[=gs.build_proc_grps]{gs.build_proc_grps()}}
}
