% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_response.R
\name{get_response}
\alias{get_response}
\title{Get Response from OpenAI Chat API}
\usage{
get_response(
  user_input = "what is a p-value in statistics?",
  system_specification = "You are a helpful assistant.",
  model = "gpt-3.5-turbo",
  api_key = Sys.getenv("OPENAI_API_KEY"),
  print_response = TRUE
)
}
\arguments{
\item{user_input}{The user's input for the chat interaction. Default is "what is a p-value in statistics?".}

\item{system_specification}{The system's role and content for the chat interaction. Default is "You are a helpful assistant.".}

\item{model}{The OpenAI language model to use. Default is "gpt-3.5-turbo".}

\item{api_key}{The API key for accessing the OpenAI API. Defaults to the value of the "OPENAI_API_KEY" environment variable.}

\item{print_response}{Logical, indicating whether to print the response. Default is TRUE.}
}
\value{
A list containing the response from the OpenAI Chat API.
}
\description{
This function sends a user input to the OpenAI Chat API and retrieves a response.
}
\examples{
response1 = get_response(user_input = "How to calculate the bonforoni corrected p values?")
response2 = get_response(user_input = paste0("Based on this data.frame in R: \n\n",
                                            dataframe_to_text(mtcars),
                                            "\n\n which variables are correlated?"))
response3 = get_response(user_input = "What are redox reactions?",
                        system_specification = "You are a knowledgeable and helpful chemist \n
                        who will answer any questions in German")

}
