% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rank_tricot2.R
\name{rank_tricot2}
\alias{rank_tricot2}
\title{Build Plackett-Luce rankings from tricot ranking dataset}
\usage{
rank_tricot2(data, id, items, input, ...)
}
\arguments{
\item{data}{a data.frame with columns specified by items and input values}

\item{id}{an index of \code{data} indicating the id column}

\item{items}{a character or numerical vector for indexing the column(s) 
containing the item names in \code{data}}

\item{input}{a character or numerical vector for indexing the column(s) 
containing the values in \code{data} to be ranked}

\item{...}{additional arguments passed to methods. See details}
}
\value{
a PlackettLuce "rankings" object, which is a matrix of dense rankings
}
\description{
Create an object of class "rankings" from tricot ranking data.
}
\examples{

library("gosset")

R = nicabean$trial

R = R[R$trait == "Vigor", ]

names(R)

R = rank_tricot2(R, id = "id", items = "item", input = "rank")

}
\references{
van Etten J., et al. (2016). Experimental Agriculture, 55(S1), 275–296.
\doi{https://doi.org/10.1017/S0014479716000739}
}
\seealso{
\code{\link[PlackettLuce]{rankings}}, \code{\link{nicabean}}

Other rank functions: 
\code{\link{rank_numeric}()},
\code{\link{rank_tricot}()},
\code{\link{set_binomialfreq}()},
\code{\link{set_paircomp}()}
}
\author{
Kauê de Sousa
}
\concept{rank functions}
