% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gm_auth.R
\name{gm_auth_configure}
\alias{gm_auth_configure}
\alias{gm_oauth_client}
\title{Edit auth configuration}
\usage{
gm_auth_configure(
  client = NULL,
  path = gm_default_oauth_client(),
  key = deprecated(),
  secret = deprecated(),
  appname = deprecated(),
  app = deprecated()
)

gm_oauth_client()
}
\arguments{
\item{client}{A Google OAuth client, presumably constructed via
\code{\link[gargle:gargle_oauth_client_from_json]{gargle::gargle_oauth_client_from_json()}}. Note, however, that it is
preferred to specify the client with JSON, using the \code{path} argument.}

\item{path}{JSON downloaded from \href{https://console.cloud.google.com}{Google Cloud Console}, containing a client id and
secret, in one of the forms supported for the \code{txt} argument of
\code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{key, secret, appname, app}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Use the
\code{path} (strongly recommended) or \code{client} argument instead.}
}
\value{
\itemize{
\item \code{gm_auth_configure()}: An object of R6 class
\link[gargle:AuthState-class]{gargle::AuthState}, invisibly.
\item \code{gm_oauth_client()}: the current user-configured OAuth client.
}
}
\description{
See the article \href{https://gmailr.r-lib.org/dev/articles/oauth-client.html}{Set up an OAuth client} for
instructions on how to get an OAuth client. Then you can use
\code{gm_auth_configure()} to register your client for use with gmailr.
\code{gm_oauth_client()} retrieves the currently configured OAuth client.
}
\examples{
\dontshow{if (rlang::is_interactive()) withAutoprint(\{ # examplesIf}
# if your OAuth client can be auto-discovered (see ?gm_default_oauth_client),
# you don't need to provide anything!
gm_auth_configure()
\dontshow{\}) # examplesIf}
# see and store the current user-configured OAuth client
(original_client <- gm_oauth_client())

# the preferred way to configure your own client is via a JSON file
# downloaded from Google Developers Console
# this example JSON is indicative, but fake
path_to_json <- system.file(
  "extdata", "client_secret_installed.googleusercontent.com.json",
  package = "gargle"
)
gm_auth_configure(path = path_to_json)

# confirm that a (fake) OAuth client is now configured
gm_oauth_client()

# restore original auth config
gm_auth_configure(client = original_client)
}
\seealso{
\code{\link[=gm_default_oauth_client]{gm_default_oauth_client()}} to learn how you can make your OAuth
client easy for gmailr to discover.

Other auth functions: 
\code{\link{gm_auth}()},
\code{\link{gm_deauth}()},
\code{\link{gm_scopes}()},
\code{\link{gmailr-configuration}}
}
\concept{auth functions}
