% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stat-distrmix-eq.R
\name{stat_distrmix_eq}
\alias{stat_distrmix_eq}
\title{Predicted equation from distribution mixture model fit}
\usage{
stat_distrmix_eq(
  mapping = NULL,
  data = NULL,
  geom = "text_npc",
  position = "identity",
  ...,
  method = "normalmixEM",
  method.args = list(),
  n.min = 10L * k,
  level = 0.95,
  k = 2,
  free.mean = TRUE,
  free.sd = TRUE,
  se = FALSE,
  fit.seed = NA,
  fm.values = TRUE,
  components = NULL,
  eq.with.lhs = TRUE,
  eq.digits = 2,
  label.x = "left",
  label.y = "top",
  hstep = 0,
  vstep = NULL,
  output.type = NULL,
  na.rm = FALSE,
  orientation = "x",
  parse = NULL,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{The aesthetic mapping, usually constructed with
\code{\link[ggplot2]{aes}}. Only needs to be set at the layer level if you
are overriding the plot defaults.}

\item{data}{A layer specific dataset, only needed if you want to override the
plot defaults.}

\item{geom}{The geometric object to use display the data}

\item{position}{The position adjustment to use for overlapping points on this
layer.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. This
can include aesthetics whose values you want to set, not map. See
\code{\link[ggplot2]{layer}} for more details.}

\item{method}{function or character If character, "normalmixEM"
or the name of a model fit function are accepted, possibly followed by the
fit function's \code{method} argument separated by a colon. The function
must return a model fit object of class \code{mixEM}.}

\item{method.args}{named list with additional arguments.}

\item{n.min}{integer Minimum number of distinct values in the mapped
variable for fitting to the attempted.}

\item{level}{Level of confidence interval to use (0.95 by default).}

\item{k}{integer Number of mixture components to fit.}

\item{free.mean, free.sd}{logical If TRUE, allow the fitted \code{mean} and/or
fitted \code{sd} to vary among the component Normal distributions.}

\item{se}{logical, if \code{TRUE} standard errors for parameter estimates
are obtained by bootstrapping.}

\item{fit.seed}{RNG seed argument passed to \code{\link[base:Random]{set.seed}()}.
Defaults to \code{NA}, which means that \code{set.seed()} will not be
called.}

\item{fm.values}{logical Add parameter estimates and their standard errors
to the returned values (`FALSE` by default.)}

\item{components}{character One of \code{"all"}, \code{"sum"}, or
\code{"members"} select which densities are returned.}

\item{eq.with.lhs}{If \code{character} the string is pasted to the front of
the equation label before parsing or a \code{logical} (see note).}

\item{eq.digits}{integer Number of digits after the decimal point to
use for parameters in labels. If \code{Inf}, use exponential
notation with three decimal places.}

\item{label.x, label.y}{\code{numeric} with range 0..1 "normalized parent
coordinates" (npc units) or character if using \code{geom_text_npc()} or
\code{geom_label_npc()}. If using \code{geom_text()} or \code{geom_label()}
numeric in native data units. If too short they will be recycled.}

\item{hstep, vstep}{numeric in npc units, the horizontal and vertical step
used between labels for different mixture model components.}

\item{output.type}{character One of "expression", "LaTeX", "text",
"markdown" or "numeric".}

\item{na.rm}{a logical indicating whether NA values should be stripped before
the computation proceeds.}

\item{orientation}{character Either "x" or "y", the mapping of the values
to which the mixture model is to be fitetd. NOT YET IMPLEMENTED!}

\item{parse}{logical Passed to the geom. If \code{TRUE}, the labels will be
parsed into expressions and displayed as described in \code{?plotmath}.
Default is \code{TRUE} if \code{output.type = "expression"} and
\code{FALSE} otherwise.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\value{
The value returned by the statistic is a data frame, with \code{n}
  rows of predicted density for each component of the mixture plus their
  sum and the corresponding vector of \code{x} values. Optionally it will
  also include additional values related to the model fit.
}
\description{
\code{stat_distrmix_eq()} fits a Normal mixture model, by default with
\code{\link[mixtools]{normalmixEM}()}. Predicted values are
computed and, by default, plotted.
}
\details{
This statistic is similar to \code{\link[ggplot2]{stat_density}} but
  instead of fitting a single distribution it can fit a mixture of two or
  more Normal distributions, using an approach related to clustering.
  Defaults are consistent between \code{stat_distrmix_line()} and
  \code{stat_distrmix_eq()}. Parameter \code{fit.seed} if not \code{NA} is used
  in a call to \code{set.seed()} immediately before calling the model fit
  function. As the fitting procedure makes use of the (pseudo-)random number
  generator (RNG), convergence can depend on it, and in such cases setting
  \code{fit.seed} to the same value in \code{\link{stat_distrmix_line}()} and in
  \code{\link{stat_distrmix_eq}()} can ensure consistency, and more
  generally, reproducibility.

  A mixture model as described above, is fitted for \code{k >= 2}, while
  \code{k == 1} is treated as a special case and a Normal distribution fitted
  with function \code{\link[MASS]{fitdistr}()}. In this case the SE values
  are exact estimates.
}
\section{Computed variables}{
 \code{stat_distrmix_eq()} provides the
  following
  variables, some of which depend on the orientation:
  \describe{\item{x}{the location of text labels}
  \item{y}{the location of text labels}
  \item{eq.label}{\code{character} string for equations}
  \item{eq.label}{\code{character} string for number of observations}
  \item{eq.label}{\code{character} string for model fit method}
  \item{lambda}{\code{numeric} the estimate of the contribution of the
 component of the mixture towards the joint density}
  \item{mu}{\code{numeric} the estimate of the mean}
  \item{sigma}{\code{numeric} the estimate of the standard deviation}
  \item{component}{A factor indexing the components of the mixture and/or
  their sum}}

  If \code{SE = TRUE} is passed then columns with standard errors for the
  parameter estimates:
  \describe{\item{lambda.se}{\code{numeric} the estimate of the contribution
  of the component of the mixture towards the joint density}
  \item{mu.se}{\code{numeric} the estimate of the mean}
  \item{sigma.se}{\code{numeric} the estimate of the standard deviation}}

  If \code{fm.values = TRUE} is passed then columns with diagnosis and
  parameters estimates are added, with the same value in each row within a
  group:
  \describe{\item{converged}{\code{logical} indicating if convergence was
  achieved}
  \item{n}{\code{numeric} the number of \code{x} values}
  \item{.size}{\code{numeric} the number of \code{density} values}
  \item{fm.class}{\code{character} the most derived class of the fitted model
   object}
  \item{fm.method}{\code{character} the method, as given by the \code{ft}
  field of the fitted model objects}}
  This is wasteful and disabled by default, but provides a simple and robust
  approach to achieve effects like colouring or hiding of the model fit line
  by group depending on the outcome of model fitting.
}

\section{Aesthetics}{
 \code{stat_distrmix_eq} expects observations mapped to
  \code{x} from a \code{numeric} variable. A new grouping is added by mapping
  as default \code{component} to the \code{group} aesthetic and
  \code{eq.label} to the label aesthetic. Additional aesthetics as
  understood by the geom (\code{"text_npc"} by default) can be set.
}

\examples{
ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "sum") +
  stat_distrmix_eq()

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "sum") +
  stat_distrmix_eq(use_label("eq", "n", "method"))

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "sum") +
  stat_distrmix_eq(geom = "label_npc")

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "sum") +
  stat_distrmix_eq(geom = "text", label.x = "center", label.y = "bottom")

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "sum") +
  stat_distrmix_eq(geom = "text", hjust = "inward")

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "members") +
  stat_distrmix_eq(components = "members")

ggplot(faithful, aes(x = waiting)) +
  stat_distrmix_line(components = "members") +
  stat_distrmix_eq(components = "members", se = TRUE)

# ggplot(faithful, aes(y = waiting)) +
#  stat_distrmix_eq(orientation = "y")

ggplot(faithful, aes(x = waiting)) +
 geom_histogram(aes(y = after_stat(density)), bins = 20) +
 stat_distrmix_line(aes(colour = after_stat(component),
                         fill = after_stat(component)),
                     geom = "area", linewidth = 1, alpha = 0.25) +
 stat_distrmix_eq(aes(colour = after_stat(component)))

ggplot(faithful, aes(x = waiting)) +
 stat_distrmix_line(aes(colour = after_stat(component),
                         fill = after_stat(component)),
                     geom = "area", linewidth = 1, alpha = 0.25,
                     components = "members") +
 stat_distrmix_eq(aes(colour = after_stat(component)),
                     components = "members")

ggplot(faithful, aes(x = waiting)) +
 stat_distrmix_line(geom = "area", linewidth = 1, alpha = 0.25,
                     colour = "black", outline.type = "upper",
                     components = "sum", se = FALSE) +
 stat_distrmix_eq(components = "sum")

# special case of no mixture
ggplot(subset(faithful, waiting > 66), aes(x = waiting)) +
  stat_distrmix_line(k = 1) +
  stat_distrmix_eq(k = 1)

ggplot(subset(faithful, waiting > 66), aes(x = waiting)) +
  stat_distrmix_line(k = 1) +
  stat_distrmix_eq(k = 1, se = TRUE)

# Inspecting the returned data using geom_debug()
gginnards.installed <- requireNamespace("gginnards", quietly = TRUE)

if (gginnards.installed)
  library(gginnards)

if (gginnards.installed)
  ggplot(faithful, aes(x = waiting)) +
    stat_distrmix_line(geom = "debug", components = "all")
    stat_distrmix_eq(geom = "debug", components = "all")

if (gginnards.installed)
  ggplot(faithful, aes(x = waiting)) +
    stat_distrmix_eq(geom = "debug", components = "sum")

if (gginnards.installed)
  ggplot(faithful, aes(x = waiting)) +
    stat_distrmix_eq(geom = "debug", components = "members")

if (gginnards.installed)
  ggplot(faithful, aes(x = waiting)) +
    stat_distrmix_eq(geom = "debug",
                      components = "members",
                      fm.values = TRUE)

}
\seealso{
Other ggplot statistics for mixture model fits.: 
\code{\link{stat_distrmix_line}()}
}
\concept{ggplot statistics for mixture model fits.}
