% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_blast.R
\name{read_blast}
\alias{read_blast}
\title{Read BLAST tab-separated output}
\usage{
read_blast(
  file,
  col_names = def_names("blast"),
  col_types = def_types("blast"),
  comment = "#",
  swap_query = FALSE,
  ...
)
}
\arguments{
\item{file}{Either a path to a file, a connection, or literal data
(either a single string or a raw vector).

Files ending in \code{.gz}, \code{.bz2}, \code{.xz}, or \code{.zip} will
be automatically uncompressed. Files starting with \verb{http://},
\verb{https://}, \verb{ftp://}, or \verb{ftps://} will be automatically
downloaded. Remote gz files can also be automatically downloaded and
decompressed.

Literal data is most useful for examples and tests. To be recognised as
literal data, the input must be either wrapped with \code{I()}, be a string
containing at least one new line, or be a vector containing at least one
string with a new line.

Using a value of \code{\link[readr:clipboard]{clipboard()}} will read from the system clipboard.}

\item{col_names}{column names to use. Defaults to \code{def_names("blast")}
compatible with blast tabular output (\verb{--outfmt 6/7} in blast++ and \code{-m8}
in blast-legacy). \code{\link[=def_names]{def_names()}} can easily be combined with extra
columns: \code{col_names = c(def_names("blast"), "more", "things")}.}

\item{col_types}{column types to use. Defaults to \code{def_types("gff3")} (see \code{\link{def_types}}).}

\item{comment}{character}

\item{swap_query}{if TRUE swap query and subject columns using \code{\link[=swap_query]{swap_query()}}
on import.}

\item{...}{additional parameters, passed to \code{read_tsv}}
}
\value{
a tibble with the BLAST output
}
\description{
Read BLAST tab-separated output
}
