% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raster_intersect_sp.R
\name{raster_intersect_sp}
\alias{raster_intersect_sp}
\title{Intersects raster and sp objects}
\usage{
raster_intersect_sp(
  x,
  y,
  features,
  save = FALSE,
  dirToSave,
  baseName = "x_intersect_y",
  format = "GTiff"
)
}
\arguments{
\item{x}{\code{Raster*} object}

\item{y}{\code{SpatialPolygonsDataFrame} object}

\item{features}{integer vector. Should some specifying features (polygons) of \code{y}
be intersected with \code{x}? When not provided, whole \code{y}
is intersected with \code{x}.}

\item{save}{logical. Should the output be saved? Default, \code{FALSE}.}

\item{dirToSave}{character specifying where to save output. Required when \code{save=TRUE}.}

\item{baseName}{character. What should be the base name of output file? Default,
\code{x_intersect_y}.}

\item{format}{character specifying output file format. See \code{\link[raster]{writeFormats}}
for all supported formats. Default, \code{"GTiff"}.}
}
\value{
An object of class identical to that of argument \code{x}
}
\description{
Straightforward application of \code{\link[raster]{crop}} and 
\code{\link[raster]{mask}} to extract the data in the intersection of
\code{Raster*} and \code{SpatialPolygonsDataframe} objects.
}
\details{
When \code{save=TRUE}, \code{\link[raster]{writeRaster}} is used with
argument \code{datatype=dataType(subset(x,1))}.
}
\examples{
\donttest{
raster_path = system.file("extdata", "MOD13Q1_NDVI_Mohinora.tif", package = "geoTS")
rasterSTACK <- stack(raster_path)
dir.create(path=paste0(system.file("extdata", package="geoTS"), "/output_raster_inter_sp"),
          showWarnings=FALSE)
dirToSave = paste0(system.file("extdata", package="geoTS"), "/output_raster_inter_sp")

raster_intersect_sp(x=rasterSTACK, y=shp_mohinora, save=TRUE, dirToSave=dirToSave, 
                    baseName="mohinora_NDVI_2001")
}

}
