% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galah_apply_profile.R
\name{apply_profile}
\alias{apply_profile}
\alias{galah_apply_profile}
\title{Apply a data quality profile}
\usage{
apply_profile(.data, ...)

galah_apply_profile(...)
}
\arguments{
\item{.data}{An object of class \code{data_request}}

\item{...}{a profile name. Should be a \code{string} - the name or abbreviation
of a data quality profile to apply to the query. Valid values can be seen
using \code{show_all(profiles)}}
}
\value{
An updated \code{data_request} with a completed \code{data_profile} slot.
}
\description{
A 'profile' is a group of filters that are pre-applied by the ALA. Using a
data profile allows a query to be filtered quickly to the most relevant or
quality-assured data that is fit-for-purpose. For example, the "ALA" profile
is designed to exclude lower quality records, whereas other profiles apply
filters specific to species distribution modelling (e.g. CDSM).

Note that only one profile can be loaded at a time; if multiple profiles are
given, the first valid profile is used.

For more bespoke editing of filters within a profile, use
\code{\link[=filter.data_request]{filter.data_request()}}.
}
\examples{
\dontrun{
# Apply a data quality profile to a query
galah_call() |> 
  identify("reptilia") |>
  filter(year == 2021) |>
  apply_profile(ALA) |>
  atlas_counts()
}
}
\seealso{
\code{\link[=show_all]{show_all()}} and \code{\link[=search_all]{search_all()}} to look up available data profiles.
\code{\link[=filter.data_request]{filter.data_request()}} can be used for more bespoke editing of individual data
profile filters.
}
