% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plugins.R
\name{minimap}
\alias{minimap}
\title{Configure Minimap Plugin}
\usage{
minimap(
  key = "minimap",
  className = NULL,
  container = NULL,
  containerStyle = NULL,
  delay = 128,
  filter = NULL,
  maskStyle = NULL,
  padding = 10,
  position = "right-bottom",
  renderer = NULL,
  shape = "key",
  size = c(240, 160),
  ...
)
}
\arguments{
\item{key}{Unique identifier for the plugin (string, default: NULL).}

\item{className}{Class name of the thumbnail canvas (string, default: NULL).}

\item{container}{Container to which the thumbnail is mounted (HTML element or string, default: NULL).}

\item{containerStyle}{Style of the thumbnail container (list or JS object, default: NULL).}

\item{delay}{Delay update time in milliseconds for performance optimization (number, default: 128).}

\item{filter}{Function to filter elements to display in minimap (JS function, default: NULL).}

\item{maskStyle}{Style of the mask (list or JS object, default: NULL).}

\item{padding}{Padding around the minimap (number or numeric vector, default: 10).}

\item{position}{Position of the thumbnail relative to the canvas
(string or numeric vector, default: "right-bottom").}

\item{renderer}{Custom renderer (JS object, default: NULL).}

\item{shape}{Method for generating element thumbnails (string or JS function, default: "key").}

\item{size}{Width and height of the minimap \code{[width, height]} (numeric vector, default: c(240, 160)).}

\item{...}{Extra parameters.
See \url{https://g6.antv.antgroup.com/en/manual/plugin/minimap}.}
}
\value{
A list with the configuration settings for the minimap plugin.
}
\description{
Creates a configuration object for the minimap plugin in G6.
This plugin adds a minimap/thumbnail view of the entire graph.
}
\examples{
# Basic configuration
config <- minimap()

# Custom configuration
config <- minimap(
  key = "my-minimap",
  position = "left-top",
  size = c(200, 150),
  padding = 15,
  containerStyle = list(
    border = "1px solid #ddd",
    borderRadius = "4px",
    boxShadow = "0 0 8px rgba(0,0,0,0.1)"
  ),
  maskStyle = list(
    stroke = "#1890ff",
    strokeWidth = 2,
    fill = "rgba(24, 144, 255, 0.1)"
  )
)

# With custom filtering function
config <- minimap(
  filter = JS("(id, elementType) => {
    // Only show nodes and important edges in the minimap
    if (elementType === 'node') return true;
    if (elementType === 'edge') {
      // Assuming edges have an 'important' attribute
      const edge = graph.findById(id);
      return edge.getModel().important === true;
    }
    return false;
  }")
)
}
