% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transpile.R
\name{transpile}
\alias{transpile}
\title{Transpile an R expression}
\usage{
transpile(
  expr,
  options = list(...),
  ...,
  when = TRUE,
  eval = TRUE,
  envir = parent.frame(),
  type = "built-in",
  what = "transpile",
  unwrap = list(base::`{`, base::`(`, base::`!`, base::local, base::I, base::identity,
    base::invisible, base::suppressMessages, base::suppressWarnings,
    base::suppressPackageStartupMessages),
  debug = FALSE
)
}
\arguments{
\item{expr}{An \R expression, typically a function call to transpile.
If FALSE, then the transpiler is disabled, and if TRUE, it is re-enabled.
If NA, then TRUE is returned if the transpiler is enabled, otherwise FALSE.}

\item{options}{(optional) Named options for the transpilation.}

\item{when}{If TRUE (default), the expression is transpiled, otherwise not.}

\item{eval}{If TRUE (default), the transpiled expression is evaluated,
otherwise it is returned.}

\item{envir}{The environment where the expression should be evaluated.}

\item{type}{Type of the transpiler to use.}

\item{unwrap}{(optional) A list of functions that should be considered
wrapping functions that the transpiler should unwrap ("enter"). This
allows us to transpile expressions within \code{{ ... }} and \code{local( ... )}.}
}
\value{
Returns the value of the evaluated expression \code{expr} if \code{eval = TRUE},
otherwise the transpiled expression.
If \code{expr} is NA, then TRUE is returned if the transpiler is enabled,
otherwise FALSE.
}
\description{
Transpile an R expression
}
\keyword{internal}
