test_that("funIHC runs on example data and returns valid output", {

  rds_path <- system.file("extdata", "U1505.rds", package = "funIHC")
  expect_true(file.exists(rds_path))

  example_data <- readRDS(rds_path)
  expect_true(is.list(example_data))
  expect_true("Data" %in% names(example_data))

  x = 1:15
  Data <- example_data$Data

  res <- funIHC(x,t(Data))

  expect_type(res, "list")
  expect_true(all(
    c("label", "clusters", "fd", "mean_clusters_mat") %in% names(res)
  ))

  expect_length(res$label, nrow(Data))
  expect_true(all(is.finite(res$label)))
})

