% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{label.border}
\alias{label.border}
\title{Compute border of a label.}
\usage{
label.border(
  surface_mesh,
  label,
  inner_only = TRUE,
  expand_inwards = 0L,
  derive = FALSE
)
}
\arguments{
\item{surface_mesh}{surface mesh, as loaded by \code{\link[fsbrain]{subject.surface}} or \code{\link[freesurferformats]{read.fs.surface}}.}

\item{label}{instance of class `fs.label` or an integer vector, the vertex indices. This function only makes sense if they form a patch on the surface, but that is not checked.}

\item{inner_only}{logical, whether only faces consisting only of label_vertices should be considered to be label faces. If FALSE, faces containing at least one label vertex will be used. Defaults to TRUE. Leave this alone if in doubt, especially if you want to draw several label borders which are directly adjacent on the surface.}

\item{expand_inwards}{integer, border thickness extension. If given, once the border has been computed, it is extended by the given graph distance. It is guaranteed that the border only extends inwards, i.e., it will never extend to vertices which are not part of the label.}

\item{derive}{logical, whether the returned result should also include the border edges and faces in addition to the border vertices. Takes longer if requested, defaults to FALSE.}
}
\value{
the border as a list with the following entries: `vertices`: integer vector, the vertex indices of the border. Iff the parameter `derive` is TRUE, the following two additional fields are included: `edges`: integer matrix of size (n, 2) for n edges. Each row defines an edge by its start and target vertex. `faces`: integer vector, the face indices of the border.
}
\description{
Compute the border of a label (i.e., a subset of the vertices of a mesh). The border thickness can be specified. Useful to draw the outline of a region, e.g., a significant cluster on the surface or a part of a ROI from a brain parcellation.
}
\seealso{
Other surface mesh functions: 
\code{\link{face.edges}()},
\code{\link{mesh.vertex.included.faces}()},
\code{\link{mesh.vertex.neighbors}()},
\code{\link{subject.surface}()},
\code{\link{vis.path.along.verts}()}
}
\concept{surface mesh functions}
