% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.jointSurroMed.R
\name{plot.jointSurroMed}
\alias{plot.jointSurroMed}
\title{Plot Method for a joint surrogate mediation analysis model.}
\usage{
\method{plot}{jointSurroMed}(x,plot.mediation="All",type.plot="Hazard",
conf.bands=TRUE,endpoint=2,
legend.pos = "topleft",...)
}
\arguments{
\item{x}{An object of class \code{jointSurroMed} from a joint surrogate model
                with a mediation analysis
for longitudinal outcome and a terminal event, i.e., an
output from calling \code{jointSurroPenal} function with the option
'mediation' set to TRUE.}

\item{plot.mediation}{A character string specifying the desired plot.
 Possible values are "All", "g","PTE" or "Effects". The default is
"All" which displays all three plots.}

\item{type.plot}{A character string specifying the type of curve
for the baseline hazards functions. Possible
value are "Hazard", or "Survival".}

\item{conf.bands}{Logical value. Determines whether confidence bands should be
plotted. The default is to do so if the confidence bands are available.}

\item{endpoint}{An integer specifying for which endpoint should
the baseline curves be plotted. Possible values are 0
for the surrogate endpoint only and 1 for the final endpoint or 2 for both.
Default is 2.}

\item{legend.pos}{The location of the legend can be specified by setting
this argument to a single keyword from the list '"bottomright"', '"bottom"',
'"bottomleft"', '"left"', '"topleft"', '"top"', '"topright"', '"right"' and
'"center"'. The default is '"topleft"'}

\item{...}{other unused arguments.}
}
\value{
Print one or several plots for the mediation analysis
of a joint surrogate model
}
\description{
Plots the estimated functions associated with the mediation analysis, i.e.
\eqn{g(s)}, \eqn{PTE(t)}
as well as the natural direct, indirect and total effects.
An option to plot the confidence bands of the function \eqn{g(s)} is available.
This option is also implemented for the confidence bands of the functions
\eqn{PTE(t)} and of the natural effects if these confidence bands are available.
}
\seealso{
\code{\link{jointSurroPenal}}
}
\keyword{file}
