% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fmesher_bary}
\alias{fmesher_bary}
\title{Barycentric coordinate computation}
\usage{
fmesher_bary(mesh_loc, mesh_tv, loc, options)
}
\arguments{
\item{mesh_loc}{numeric matrix; mesh vertex coordinates}

\item{mesh_tv}{3-column integer matrix with 0-based vertex indices for each triangle}

\item{loc}{numeric matrix; coordinates of points to locate in the mesh}

\item{options}{list of triangulation options}
}
\value{
A list with vector \code{index} (triangle index) and matrix \code{where}
(3-column barycentric matrix)
}
\description{
Locate points and compute triangular barycentric coordinates
}
\examples{
m <- fmesher_rcdt(list(cet_margin = 1), matrix(0, 1, 2))
b <- fmesher_bary(m$s,
                  m$tv,
                  matrix(c(0.5, 0.5), 1, 2),
                  list())
}
