% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crs.R
\name{fm_crs_is_null}
\alias{fm_crs_is_null}
\alias{is.na.fm_crs}
\title{Check if a crs is NULL or NA}
\usage{
fm_crs_is_null(x, crsonly = FALSE)

\method{is.na}{fm_crs}(x)
}
\arguments{
\item{x}{An object supported by \code{fm_crs(x)}}

\item{crsonly}{For crs objects with extended functionality, such as
\code{\link[=fm_crs]{fm_crs()}} objects with \code{oblique} information, \code{crsonly = TRUE} only checks
the plain CRS part.}
}
\value{
logical
}
\description{
Methods of checking whether various kinds of CRS objects are \code{NULL} or \code{NA}.
Logically equivalent to either \code{is.na(fm_crs(x))} or
\code{is.na(fm_crs(x, oblique = NA))}, but with a short-cut pre-check for
\code{is.null(x)}.
}
\section{Functions}{
\itemize{
\item \code{fm_crs_is_null()}: Check if an object is or has \code{NULL} or \code{NA} CRS
information. If not \code{NULL}, \code{is.na(fm_crs(x))} is returned. This allows the
input to be e.g. a proj4string or epsg number, since the default \code{\link[=fm_crs]{fm_crs()}}
method passes its argument on to \code{sf::st_crs()}.

\item \code{is.na(fm_crs)}: Check if a \code{fm_crs} has \code{NA} crs information and
\code{NA} obliqueness

}}
\examples{
fm_crs_is_null(NULL)
fm_crs_is_null(27700)
fm_crs_is_null(fm_crs())
fm_crs_is_null(fm_crs(27700))
fm_crs_is_null(fm_crs(oblique = c(1, 2, 3, 4)))
fm_crs_is_null(fm_crs(oblique = c(1, 2, 3, 4)), crsonly = TRUE)
fm_crs_is_null(fm_crs(27700, oblique = c(1, 2, 3, 4)))
fm_crs_is_null(fm_crs(27700, oblique = c(1, 2, 3, 4)), crsonly = TRUE)

}
\seealso{
\code{\link[=fm_crs]{fm_crs()}}, \link[=fm_crs]{fm_CRS()}, \code{\link[=fm_crs_is_identical]{fm_crs_is_identical()}}
}
