% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score-cross_tab.R
\docType{data}
\name{score_xtab_pval_chisq}
\alias{score_xtab_pval_chisq}
\alias{score_xtab_pval_fisher}
\title{Scoring via the chi-squared test or Fisher's exact test}
\format{
An object of class \code{filtro::class_score_xtab} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.

An object of class \code{filtro::class_score_xtab} (inherits from \code{filtro::class_score}, \code{S7_object}) of length 1.
}
\usage{
score_xtab_pval_chisq

score_xtab_pval_fisher
}
\value{
An S7 object. The primary property of interest is in \code{results}. This
is a data frame of results that is populated by the \code{fit()} method and has
columns:
\itemize{
\item \code{name}: The name of the score (e.g., \code{pval_chisq}).
\item \code{score}: The estimates for each predictor.
\item \code{outcome}: The name of the outcome column.
\item \code{predictor}: The names of the predictor inputs.
}

These data are accessed using \code{object@results} (see examples below).
}
\description{
These two objects can be used to compute importance scores based on
chi-squared test or Fisher's exact test.
}
\details{
These objects are used when:
\itemize{
\item The predictors are factors and the outcome is a factor.
}

In this case, a contingency table (via \code{\link[=table]{table()}}) is created with the proper
variable roles, and the cross tabulation p-value is computed using either
the chi-squared test (via \code{\link[stats:chisq.test]{stats::chisq.test()}}) or Fisher's exact test
(via \code{\link[stats:fisher.test]{stats::fisher.test()}}). The p-value that is returned is transformed to
be \code{-log10(p_value)} so that larger values are associated with more important
predictors.
\subsection{Estimating the scores}{

In \pkg{filtro}, the \verb{score_*} objects define a scoring method (e.g., data
input requirements, package dependencies, etc). To compute the scores for
a specific data set, the \code{fit()} method is used. The main arguments for
these functions are:

\describe{
\item{\code{object}}{A score class object (e.g., \code{score_xtab_pval_chisq}).}
\item{\code{formula}}{A standard R formula with a single outcome on the right-hand side and one or more predictors (or \code{.}) on the left-hand side. The data are processed via \code{\link[stats:model.frame]{stats::model.frame()}}}
\item{\code{data}}{A data frame containing the relevant columns defined by the formula.}
\item{\code{...}}{Further arguments passed to or from other methods.}
\item{\code{case_weights}}{A quantitative vector of case weights that is the same length as the number of rows in \code{data}. The default of \code{NULL} indicates that there are no case weights.}
}
}

Missing values are removed for each predictor/outcome combination being
scored.

In cases where the underlying computations fail, the scoring proceeds
silently, and a missing value is given for the score.
}
\examples{
\dontshow{if (rlang::is_installed(c("titanic", "modeldata"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Binary factor example

library(titanic)
library(dplyr)

titanic_subset <- titanic_train |>
  mutate(across(c(Survived, Pclass, Sex, Embarked), as.factor)) |>
  select(Survived, Pclass, Sex, Age, Fare, Embarked)

# Chi-squared test
titanic_xtab_pval_chisq_res <- score_xtab_pval_chisq |>
  fit(Survived ~ ., data = titanic_subset)
titanic_xtab_pval_chisq_res@results

# Chi-squared test adjusted p-values
titanic_xtab_pval_chisq_p_adj_res <- score_xtab_pval_chisq |>
  fit(Survived ~ ., data = titanic_subset, adjustment = "BH")

# Fisher's exact test
titanic_xtab_pval_fisher_res <- score_xtab_pval_fisher |>
  fit(Survived ~ ., data = titanic_subset)
titanic_xtab_pval_fisher_res@results

# Chi-squared test where `class` is the multiclass outcome/response

hpc_subset <- modeldata::hpc_data |>
  dplyr::select(
    class,
    protocol,
    hour
  )

hpc_xtab_pval_chisq_res <- score_xtab_pval_chisq |>
    fit(class ~ ., data = hpc_subset)
hpc_xtab_pval_chisq_res@results
\dontshow{\}) # examplesIf}
}
\seealso{
Other class score metrics: 
\code{\link{score_aov_pval}},
\code{\link{score_cor_pearson}},
\code{\link{score_imp_rf}},
\code{\link{score_info_gain}},
\code{\link{score_roc_auc}}
}
\concept{class score metrics}
\keyword{datasets}
